package com.ellabook.entity.analysis;

import lombok.AllArgsConstructor;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

@AllArgsConstructor
public class DailyData {
    private Integer totalActiveUser; //总活跃用户
    private Integer appleActiveUser; //IOS活跃用户
    private Integer androidActiveUser; //安卓活跃用户

    private Integer totalIncreaseUserNum; //新增用户总数数
    private Integer registerIncreaseUserNum; //新增注册用户数
    private Integer appleIncreaseUserNum; //苹果新增用户数
    private Integer androidIncreaseUserNum; //安卓新增用户数

    private BigDecimal increasePayAmount; //新增付费金额
    private Integer increasePayUserNum; //新增付费用户数
    private BigDecimal appleIncreasePayAmount; //苹果新增付费金额
    private Integer appleIncreasePayUserNum; //苹果新增付费用户数
    private BigDecimal androidIncreasePayAmount; //安卓新增付费金额
    private Integer androidIncreasePayUserNum; //安卓新增付费用户数

    private String increasePayUserRate; //付费⽤用户⽐例（当⽇日新增付费⽤用户数/当⽇日实际新增⽤用户数

    private Integer applePayNum; //苹果付费用户数
    private BigDecimal applePayAmount;//苹果付费金额
    private Integer wxpayNum;//微信付费用户数
    private BigDecimal wxpayAmount;//微信付费金额
    private Integer alipayNum;//支付宝付费用户数
    private BigDecimal alipayAmount;//支付宝付费金额
    private Integer huaweiPayNum;//华为付费用户数
    private BigDecimal huaweiPayAmount;//华为付费金额

    private Integer rechargeUserNum;//充值人数
    private BigDecimal rechargeAmount;//充值金额
    private Integer subscribeUserNum;//订阅用户数
    private BigDecimal subscribeAmount;//订阅金额
    private Integer totalPayNum;//总充值金额
    private BigDecimal totalPayAmount;//充值用户数


    private Integer increaseRechargeUserNum;//新增充值用户数
    private BigDecimal increaseRechargeAmount;//新增充值金额

    private Integer increaseSubscribeUserNum;//新增订阅用户数
    private BigDecimal increaseSubscribeAmount;//新增订阅金额

    private Integer readNum;//阅读人数
    private Integer avgReadTime;//平均阅读时长
    private String activeReadRate;//阅读活跃比例
    private List<DailyChannel> channelList;
    private List<Map> channelAmountList;//渠道付费金额列表

    public DailyData() {
    }

    public DailyData(Integer totalActiveUser, Integer appleActiveUser, Integer androidActiveUser, Integer totalIncreaseUserNum,
                     Integer registerIncreaseUserNum, Integer appleIncreaseUserNum, Integer androidIncreaseUserNum, BigDecimal increasePayAmount,
                     Integer increasePayUserNum, BigDecimal appleIncreasePayAmount, Integer appleIncreasePayUserNum, BigDecimal androidIncreasePayAmount,
                     Integer androidIncreasePayUserNum, String increasePayUserRate, Integer applePayNum, BigDecimal applePayAmount, Integer wxpayNum,
                     BigDecimal wxpayAmount, Integer alipayNum, BigDecimal alipayAmount, Integer increaseRechargeUserNum,
                     BigDecimal increaseRechargeAmount, Integer increaseSubscribeUserNum, BigDecimal increaseSubscribeAmount, Integer readNum,
                     Integer avgReadTime, String activeReadRate) {
        this.totalActiveUser = totalActiveUser;
        this.appleActiveUser = appleActiveUser;
        this.androidActiveUser = androidActiveUser;
        this.totalIncreaseUserNum = totalIncreaseUserNum;
        this.registerIncreaseUserNum = registerIncreaseUserNum;
        this.appleIncreaseUserNum = appleIncreaseUserNum;
        this.androidIncreaseUserNum = androidIncreaseUserNum;
        this.increasePayAmount = increasePayAmount;
        this.increasePayUserNum = increasePayUserNum;
        this.appleIncreasePayAmount = appleIncreasePayAmount;
        this.appleIncreasePayUserNum = appleIncreasePayUserNum;
        this.androidIncreasePayAmount = androidIncreasePayAmount;
        this.androidIncreasePayUserNum = androidIncreasePayUserNum;
        this.increasePayUserRate = increasePayUserRate;
        this.applePayNum = applePayNum;
        this.applePayAmount = applePayAmount;
        this.wxpayNum = wxpayNum;
        this.wxpayAmount = wxpayAmount;
        this.alipayNum = alipayNum;
        this.alipayAmount = alipayAmount;
        this.increaseRechargeUserNum = increaseRechargeUserNum;
        this.increaseRechargeAmount = increaseRechargeAmount;
        this.increaseSubscribeUserNum = increaseSubscribeUserNum;
        this.increaseSubscribeAmount = increaseSubscribeAmount;
        this.readNum = readNum;
        this.avgReadTime = avgReadTime;
        this.activeReadRate = activeReadRate;
    }

    public DailyData(Integer totalActiveUser, Integer appleActiveUser, Integer androidActiveUser, Integer totalIncreaseUserNum,
                     Integer registerIncreaseUserNum, Integer appleIncreaseUserNum, Integer androidIncreaseUserNum,
                     BigDecimal increasePayAmount, Integer increasePayUserNum, BigDecimal appleIncreasePayAmount,
                     Integer appleIncreasePayUserNum, BigDecimal androidIncreasePayAmount, Integer androidIncreasePayUserNum,
                     String increasePayUserRate, Integer applePayNum, BigDecimal applePayAmount, Integer wxpayNum, BigDecimal wxpayAmount,
                     Integer alipayNum, BigDecimal alipayAmount, Integer huaweiPayNum, BigDecimal huaweiPayAmount,
                     Integer increaseRechargeUserNum, BigDecimal increaseRechargeAmount, Integer increaseSubscribeUserNum,
                     BigDecimal increaseSubscribeAmount, Integer readNum, Integer avgReadTime, String activeReadRate,
                     List<DailyChannel> channelList) {
        this.totalActiveUser = totalActiveUser;
        this.appleActiveUser = appleActiveUser;
        this.androidActiveUser = androidActiveUser;
        this.totalIncreaseUserNum = totalIncreaseUserNum;
        this.registerIncreaseUserNum = registerIncreaseUserNum;
        this.appleIncreaseUserNum = appleIncreaseUserNum;
        this.androidIncreaseUserNum = androidIncreaseUserNum;
        this.increasePayAmount = increasePayAmount;
        this.increasePayUserNum = increasePayUserNum;
        this.appleIncreasePayAmount = appleIncreasePayAmount;
        this.appleIncreasePayUserNum = appleIncreasePayUserNum;
        this.androidIncreasePayAmount = androidIncreasePayAmount;
        this.androidIncreasePayUserNum = androidIncreasePayUserNum;
        this.increasePayUserRate = increasePayUserRate;
        this.applePayNum = applePayNum;
        this.applePayAmount = applePayAmount;
        this.wxpayNum = wxpayNum;
        this.wxpayAmount = wxpayAmount;
        this.alipayNum = alipayNum;
        this.alipayAmount = alipayAmount;
        this.huaweiPayNum = huaweiPayNum;
        this.huaweiPayAmount = huaweiPayAmount;
        this.increaseRechargeUserNum = increaseRechargeUserNum;
        this.increaseRechargeAmount = increaseRechargeAmount;
        this.increaseSubscribeUserNum = increaseSubscribeUserNum;
        this.increaseSubscribeAmount = increaseSubscribeAmount;
        this.readNum = readNum;
        this.avgReadTime = avgReadTime;
        this.activeReadRate = activeReadRate;
        this.channelList = channelList;
    }

    public Integer getHuaweiPayNum() {
        return huaweiPayNum;
    }

    public void setHuaweiPayNum(Integer huaweiPayNum) {
        this.huaweiPayNum = huaweiPayNum;
    }

    public BigDecimal getHuaweiPayAmount() {
        return huaweiPayAmount;
    }

    public void setHuaweiPayAmount(BigDecimal huaweiPayAmount) {
        this.huaweiPayAmount = huaweiPayAmount;
    }

    public Integer getTotalActiveUser() {
        return totalActiveUser;
    }

    public void setTotalActiveUser(Integer totalActiveUser) {
        this.totalActiveUser = totalActiveUser;
    }

    public Integer getAppleActiveUser() {
        return appleActiveUser;
    }

    public void setAppleActiveUser(Integer appleActiveUser) {
        this.appleActiveUser = appleActiveUser;
    }

    public Integer getAndroidActiveUser() {
        return androidActiveUser;
    }

    public void setAndroidActiveUser(Integer androidActiveUser) {
        this.androidActiveUser = androidActiveUser;
    }

    public Integer getTotalIncreaseUserNum() {
        return totalIncreaseUserNum;
    }

    public void setTotalIncreaseUserNum(Integer totalIncreaseUserNum) {
        this.totalIncreaseUserNum = totalIncreaseUserNum;
    }

    public Integer getRegisterIncreaseUserNum() {
        return registerIncreaseUserNum;
    }

    public void setRegisterIncreaseUserNum(Integer registerIncreaseUserNum) {
        this.registerIncreaseUserNum = registerIncreaseUserNum;
    }

    public Integer getAppleIncreaseUserNum() {
        return appleIncreaseUserNum;
    }

    public void setAppleIncreaseUserNum(Integer appleIncreaseUserNum) {
        this.appleIncreaseUserNum = appleIncreaseUserNum;
    }

    public Integer getAndroidIncreaseUserNum() {
        return androidIncreaseUserNum;
    }

    public void setAndroidIncreaseUserNum(Integer androidIncreaseUserNum) {
        this.androidIncreaseUserNum = androidIncreaseUserNum;
    }

    public BigDecimal getIncreasePayAmount() {
        return increasePayAmount;
    }

    public void setIncreasePayAmount(BigDecimal increasePayAmount) {
        this.increasePayAmount = increasePayAmount;
    }

    public Integer getIncreasePayUserNum() {
        return increasePayUserNum;
    }

    public void setIncreasePayUserNum(Integer increasePayUserNum) {
        this.increasePayUserNum = increasePayUserNum;
    }

    public BigDecimal getAppleIncreasePayAmount() {
        return appleIncreasePayAmount;
    }

    public void setAppleIncreasePayAmount(BigDecimal appleIncreasePayAmount) {
        this.appleIncreasePayAmount = appleIncreasePayAmount;
    }

    public Integer getAppleIncreasePayUserNum() {
        return appleIncreasePayUserNum;
    }

    public void setAppleIncreasePayUserNum(Integer appleIncreasePayUserNum) {
        this.appleIncreasePayUserNum = appleIncreasePayUserNum;
    }

    public BigDecimal getAndroidIncreasePayAmount() {
        return androidIncreasePayAmount;
    }

    public void setAndroidIncreasePayAmount(BigDecimal androidIncreasePayAmount) {
        this.androidIncreasePayAmount = androidIncreasePayAmount;
    }

    public Integer getAndroidIncreasePayUserNum() {
        return androidIncreasePayUserNum;
    }

    public void setAndroidIncreasePayUserNum(Integer androidIncreasePayUserNum) {
        this.androidIncreasePayUserNum = androidIncreasePayUserNum;
    }

    public String getIncreasePayUserRate() {
        return increasePayUserRate;
    }

    public void setIncreasePayUserRate(String increasePayUserRate) {
        this.increasePayUserRate = increasePayUserRate;
    }

    public Integer getApplePayNum() {
        return applePayNum;
    }

    public void setApplePayNum(Integer applePayNum) {
        this.applePayNum = applePayNum;
    }

    public BigDecimal getApplePayAmount() {
        return applePayAmount;
    }

    public void setApplePayAmount(BigDecimal applePayAmount) {
        this.applePayAmount = applePayAmount;
    }

    public Integer getWxpayNum() {
        return wxpayNum;
    }

    public void setWxpayNum(Integer wxpayNum) {
        this.wxpayNum = wxpayNum;
    }

    public BigDecimal getWxpayAmount() {
        return wxpayAmount;
    }

    public void setWxpayAmount(BigDecimal wxpayAmount) {
        this.wxpayAmount = wxpayAmount;
    }

    public Integer getAlipayNum() {
        return alipayNum;
    }

    public void setAlipayNum(Integer alipayNum) {
        this.alipayNum = alipayNum;
    }

    public BigDecimal getAlipayAmount() {
        return alipayAmount;
    }

    public void setAlipayAmount(BigDecimal alipayAmount) {
        this.alipayAmount = alipayAmount;
    }

    public Integer getIncreaseRechargeUserNum() {
        return increaseRechargeUserNum;
    }

    public void setIncreaseRechargeUserNum(Integer increaseRechargeUserNum) {
        this.increaseRechargeUserNum = increaseRechargeUserNum;
    }

    public BigDecimal getIncreaseRechargeAmount() {
        return increaseRechargeAmount;
    }

    public void setIncreaseRechargeAmount(BigDecimal increaseRechargeAmount) {
        this.increaseRechargeAmount = increaseRechargeAmount;
    }

    public Integer getIncreaseSubscribeUserNum() {
        return increaseSubscribeUserNum;
    }

    public void setIncreaseSubscribeUserNum(Integer increaseSubscribeUserNum) {
        this.increaseSubscribeUserNum = increaseSubscribeUserNum;
    }

    public BigDecimal getIncreaseSubscribeAmount() {
        return increaseSubscribeAmount;
    }

    public void setIncreaseSubscribeAmount(BigDecimal increaseSubscribeAmount) {
        this.increaseSubscribeAmount = increaseSubscribeAmount;
    }

    public Integer getReadNum() {
        return readNum;
    }

    public void setReadNum(Integer readNum) {
        this.readNum = readNum;
    }

    public Integer getAvgReadTime() {
        return avgReadTime;
    }

    public void setAvgReadTime(Integer avgReadTime) {
        this.avgReadTime = avgReadTime;
    }

    public String getActiveReadRate() {
        return activeReadRate;
    }

    public void setActiveReadRate(String activeReadRate) {
        this.activeReadRate = activeReadRate;
    }

    public List<DailyChannel> getChannelList() {
        return channelList;
    }

    public void setChannelList(List<DailyChannel> channelList) {
        this.channelList = channelList;
    }

    public Integer getRechargeUserNum() {
        return rechargeUserNum;
    }

    public void setRechargeUserNum(Integer rechargeUserNum) {
        this.rechargeUserNum = rechargeUserNum;
    }

    public BigDecimal getRechargeAmount() {
        return rechargeAmount;
    }

    public void setRechargeAmount(BigDecimal rechargeAmount) {
        this.rechargeAmount = rechargeAmount;
    }

    public Integer getSubscribeUserNum() {
        return subscribeUserNum;
    }

    public void setSubscribeUserNum(Integer subscribeUserNum) {
        this.subscribeUserNum = subscribeUserNum;
    }

    public BigDecimal getSubscribeAmount() {
        return subscribeAmount;
    }

    public void setSubscribeAmount(BigDecimal subscribeAmount) {
        this.subscribeAmount = subscribeAmount;
    }

    public Integer getTotalPayNum() {
        return totalPayNum;
    }

    public void setTotalPayNum(Integer totalPayNum) {
        this.totalPayNum = totalPayNum;
    }

    public BigDecimal getTotalPayAmount() {
        return totalPayAmount;
    }

    public void setTotalPayAmount(BigDecimal totalPayAmount) {
        this.totalPayAmount = totalPayAmount;
    }

    public List<Map> getChannelAmountList() {
        return channelAmountList;
    }

    public void setChannelAmountList(List<Map> channelAmountList) {
        this.channelAmountList = channelAmountList;
    }
}