package com.ellabook.entity.analysis;

import lombok.AllArgsConstructor;

import java.util.Objects;

/**
 * @Author: chenlili
 * @Description: 打点枚举
 * @Date:Created 2018/7/18 11:16
 * @Modified By:
 */
@AllArgsConstructor
public enum AppLogsEventEnum {

    INTRODUCE_READ_FREE(2, "图书介绍页_免费试读", "introduce_readfree"),
    INTRODUCE_BUY(3, "图书介绍页_立即购买", "introduce_buy"),//1
    //    INTRODUCE_BUY(4,"图书介绍页_立即购买","introduce_buy"),//2
//    INTRODUCE_BUY(5,"图书介绍页_立即购买","introduce_buy"),//3
    INTRODUCE_MEMBER_READ(6, "图书介绍页_会员免费读", "introduce_memberread"),
    DETAIL_DOWNLOAD_ONE(7, "详情页下载完成", "detail_downloadone"),//3
    DETAIL_UNDERSTANDING_VIP(8, "详情页_了解会员", "detail_understandingVIP"),
    PROBATION_LAST_BUY_FULL(9, "购买完整版", "probationlast_buyfull"),
    PAY(10, "图书支付页", "pay"),
    PAY_PAY(11, "图书支付页_立即支付", "pay_pay"),//1
    //    PAY_PAY(12,"图书支付页_立即支付","pay_pay"),//2
//    PAY_PAY(13,"图书支付页_立即支付","pay_pay"),//3
//    PAY_PAY(14,"图书支付页_立即支付","pay_pay"),//4
    RECHARGE(15, "充值页", "recharge"),
//    RECHARGE_PAY(16,"充值页_立即支付","recharge_pay"),//1
//    RECHARGE_PAY(17,"充值页_立即支付","recharge_pay"),//2
//    RECHARGE_PAY(18,"充值页_立即支付","recharge_pay"),//3
//    RECHARGE_PAY(19,"充值页_立即支付","recharge_pay"),//4

    AFFIRM_PAY(20, "确认支付", "affirmpay"),//1
    //    AFFIRM_PAY(21,"确认支付","affirmpay"),//2
//    AFFIRM_PAY(22,"确认支付","affirmpay"),//3
    COIN(23, "“我的咿啦币”页", "coin"),
    COIN_RECHARGE(24, "我的咿啦币_去充值", "coin_recharge"),
//    AFFIRM_PAY(25,"确认支付","affirmpay"),//4

    MEMBER(26, "“我的会员”页", "member"),
//    MEMBER(26,"“我的会员”页-1.总浏览数","member"),
//    MEMBER(27,"“我的会员”页-2.试读最后页点击“开通会员”按钮进入“我的会员”页","member"),
//    MEMBER(28,"“我的会员”页-3.“我的--我的会员”入口进入“我的会员”页","member"),

    MEMBER_BUY(29, "我的会员_会员卡购买", "member_buy"),//1
    //    MEMBER_BUY(30,"我的会员_会员卡购买","member_buy"),//2
//    MEMBER_BUY(31,"我的会员_会员卡购买","member_buy"),//3
//    MEMBER_BUY(32,"我的会员_会员卡购买","member_buy"),//1
//    MEMBER_BUY(33,"我的会员_会员卡购买","member_buy"),//2
//    MEMBER_BUY(34,"我的会员_会员卡购买","member_buy"),//3
    PROBATION_LAST(35, "试读最后页", "probationlast"),
    PROBATION_LAST_OPEN_MEMBER(36, "试读最后页_开通会员", "probationlast_openmember"),
    LOG(37, "登录页", "log"),
    //    LOG(37,"登录页-1.总浏览数","log"),
//    LOG(38,"登录页-2.新下载app进入该页面","log"),
//    LOG(39,"登录页-3.点击“我的—未登录”进入","log"),
//    LOG(40,"登录页-4.点击首页左上角儿童模式图标进入","log"),
//    LOG(41,"登录页-5.点击“我的--添加宝宝”进入","log"),
//    LOG(42,"登录页-6.点击“我的--红包”进入","log"),
//    LOG(43,"登录页-7.会员页点击购买按钮进入","log"),
//    LOG(44,"登录页-8.点击“写书评”按钮进入","log"),
    LOG_FORGET_PASSWORD(45, "log_forgetpassword", "log_forgetpassword"),//LOG_FORGET_PASSWORD(45,"5","log_forgetpassword"),

    LOG_NO_HAVE(46, "登录注册_登录", "log_nohave"),
    LOG_SIGN_ACCOUNT(47, "登录注册_注册账号", "log_signaccount"),
    LOG_SHARE_THIRD(48, "登录注册_点击选择某个第三方", "log_sharethird"),//1
    //    LOG_SHARE_THIRD(49,"登录注册_点击选择某个第三方","log_sharethird"),//2
//    LOG_SHARE_THIRD(50,"登录注册_点击选择某个第三方","log_sharethird"),//3
//    LOG_SHARE_THIRD(51,"登录注册_点击选择某个第三方","log_sharethird"),//4
    LOG_CLOSE(52, "登录注册_点击页面左上角关闭图标", "log_close"),
    FORGET_CODE(53, "忘记密码页", "forgetcode"),
    FORGET_CODE_VERIFICATION(54, "忘记密码_获取验证码", "forgetcode_verification"),
    FORGET_CODE_NEXT(55, "忘记密码_下一步", "forgetcode_next"),
    FORGET_CODE_FINISH(56, "忘记密码_完成", "forgetcode_finish"),
    SIGN(57, "注册账号页", "sign"),
    SIGN_VERIFICATION(58, "注册账号_获取验证码", "sign_verification"),
    SIGN_SIGN(59, "注册账号_注册", "sign_sign"),
    SIGN_AGREEMENT(60, "注册账号_用户协议", "sign_agreement"),
    SIGN_LOG_HAVE(61, "注册账号_已有账号去登录", "sign_loghave"),
    SIGN_SHARE_THIRD(62, "注册账号_点击选择某个第三方", "sign_sharethird"),//1
    //    SIGN_SHARE_THIRD(63,"注册账号_点击选择某个第三方","sign_sharethird"),//2
//    SIGN_SHARE_THIRD(64,"注册账号_点击选择某个第三方","sign_sharethird"),//3
//    SIGN_SHARE_THIRD(65,"注册账号_点击选择某个第三方","sign_sharethird"),//4
    HOME(66, "首页", "home"),
    HOME_BANNER(67, "首页_banner位", "home_banner"),//1
    //    HOME_BANNER(68,"首页_banner位","home_banner"),//2
//    HOME_BANNER(69,"首页_banner位","home_banner"),//3
//    HOME_BANNER(70,"首页_banner位","home_banner"),//4
//    HOME_BANNER(71,"首页_banner位","home_banner"),//5
    HOME_ENTRANCE(72, "首页_导航入口位", "home_entrance"),//1
//    HOME_ENTRANCE(73,"首页_导航入口位","home_entrance"),//2
//    HOME_ENTRANCE(74,"首页_导航入口位","home_entrance"),//3
//    HOME_ENTRANCE(75,"首页_导航入口位","home_entrance"),//4

    HOME_PART(76, "首页_栏目", "home_part"),
//    HOME_PART(76,"首页_今日推荐的“更多”按钮","home_part"),
//    HOME_PART(77,"首页_今日推荐模块点击绘本","home_part"),
//    HOME_PART(78,"首页_新书抢鲜看的“更多”按钮","home_part"),
//    HOME_PART(79,"首页_新书抢鲜看模块点击绘本","home_part"),
//    HOME_PART(80,"首页_妈妈陪我读绘本的“更多”按钮","home_part"),
//    HOME_PART(81,"首页_妈妈陪我读绘本模块点击绘本","home_part"),
//    HOME_PART(82,"首页_爸爸陪我读绘本的“更多”按钮","home_part"),
//    HOME_PART(83,"首页_爸爸陪我读绘本模块点击绘本","home_part"),
//    HOME_PART(84,"首页_家有二胎绘本推荐的“更多”按钮","home_part"),
//    HOME_PART(85,"首页_家有二胎绘本推荐模块点击绘本","home_part"),
//    HOME_PART(86,"首页_玩着学口语的“更多“按钮","home_part"),
//    HOME_PART(87,"首页_玩着学口语模块点击绘本","home_part"),
//    HOME_PART(88,"首页_国际大奖绘本的“更多“按钮","home_part"),
//    HOME_PART(89,"首页_国际大奖绘本模块点击绘本","home_part"),
//    HOME_PART(90,"首页_0-3岁孩子必buy的“更多“按钮","home_part"),
//    HOME_PART(91,"首页_0-3岁孩子必buy模块点击绘本","home_part"),
//    HOME_PART(92,"首页_3-6岁孩子必buy的“更多“按钮","home_part"),
//    HOME_PART(93,"首页_3-6岁孩子必buy模块点击绘本","home_part"),
//    HOME_PART(94,"首页_晚安我的宝贝的“更多“按钮","home_part"),
//    HOME_PART(95,"首页_晚安我的宝贝模块点击 绘本","home_part"),
//    HOME_PART(96,"首页_猜你喜欢的“更多“按钮","home_part"),
//    HOME_PART(97,"首页_猜你喜欢模块点击绘本","home_part"),

    HOME_SEARCH(98, "首页_点击搜索框", "home_search"),
    SEARCH(99, "搜索页", "search"),
    SEARCH_SEARCH(100, "搜索_搜索", "search_search"),
    SEARCH_CANCEL(101, "搜索_取消", "search_cancel"),
    SEARCH_BOOK(102, "搜索_搜索结果中的绘本", "search_book"),
    SEARCH_INDEXES(103, "搜索_分类索引", "search_indexes"),
    SEARCH_RECORD(104, "搜索_搜索记录", "search_record"),
    STUDY(105, "书房页", "study"),
    STUDY_RECENT(106, "书房_点击查看最近在读绘本", "study_recent"),
    STUDY_MY(107, "书房_点击查看已加绘本", "study_my"),
    STUDY_DOWNLOAD_ONE(108, "书房_点击单个绘本下载", "study_downloadone"),
//    STUDY_DOWNLOAD_ONE(108,"书房_点击单个绘本下载-1.下载","study_downloadone"),
//    STUDY_DOWNLOAD_ONE(109,"书房_点击单个绘本下载-2.暂停下载","study_downloadone"),

    STUDY_EDIT(110, "书房_编辑图标", "study_edit"),
    STUDY_DOWNLOAD_BATCH(111, "书房_批量下载", "study_downloadbatch"),
    STUDY_DELETE_BATCH(112, "书房_批量删除", "study_deletebatch"),
    STUDY_SHOW_FILTER(113, "书房_筛选下拉", "study_showfilter"),
    STUDY_FILTER(114, "书房_筛选条件", "study_filter"),//1
    //    STUDY_FILTER(115,"书房_筛选条件","study_filter"),//2
//    STUDY_FILTER(116,"书房_筛选条件","study_filter"),//3
//    STUDY_FILTER(117,"书房_筛选条件","study_filter"),//4
//    STUDY_FILTER(118,"书房_筛选条件","study_filter"),//5
//    STUDY_FILTER(119,"书房_筛选条件","study_filter"),//6
    STUDY_CHILD(120, "书房_儿童模式", "study_child"),
    STUDY_SEARCH_BOX(121, "书房_搜索框", "study_searchbox"),
    STUDY_SEARCH(122, "书房_搜索", "study_search"),
    STUDY_BUTTON_CANCEL_SEARCH(123, "书房_搜索取消按钮", "study_buttoncancelseasrch"),
    STUDY_MATTE_CANCEL_SEARCH(124, "书房_点击蒙层取消搜索", "study_mattecancelseasrch"),
    STUDY_SEARCH_RESULT(125, "书房_搜索结果中的绘本", "study_searchresult"),
//    STUDY_DOWNLOAD_ONE(126,"书房下载完成","study_downloadone"),//3

    INTRODUCE(127, "图书介绍页", "introduce"),
    BOOK_DETAIL(128, "进入书籍详情", "book_detail"),//msg：书籍code
    INTRODUCE_READ(129, "图书介绍_阅读", "introduce_read"),//1
    //    INTRODUCE_READ(130,"图书介绍_阅读","introduce_read"),//2
//    INTRODUCE_READ(131,"图书介绍_阅读","introduce_read"),//3
    INTRODUCE_SHARE(132, "图书介绍_分享", "introduce_share"),
    INTRODUCE_SHARE_THIRD(133, "图书介绍_选择第三方分享方式", "introduce_sharethird"),//1
    //    INTRODUCE_SHARE_THIRD(134,"图书介绍_选择第三方分享方式","introduce_sharethird"),//2
//    INTRODUCE_SHARE_THIRD(135,"图书介绍_选择第三方分享方式","introduce_sharethird"),//3
//    INTRODUCE_SHARE_THIRD(136,"图书介绍_选择第三方分享方式","introduce_sharethird"),//4
//    INTRODUCE_SHARE_THIRD(137,"图书介绍_选择第三方分享方式","introduce_sharethird"),//5
//    INTRODUCE_SHARE_THIRD(138,"图书介绍_选择第三方分享方式","introduce_sharethird"),//6
    INTRODUCE_VIDEO(139, "图书介绍_预览视频", "introduce_video"),
    INTRODUCE_PICTURE(140, "图书介绍_预览图片", "introduce_picture"),
    INTRODUCE_INFO(141, "图书介绍_出版与制作信息", "introduce_info"),
    INTRODUCE_SHOW_WORD(142, "图书介绍_展开简介", "introduce_showword"),
    INTRODUCE_HIDE_WORD(143, "图书介绍_收起简介", "introduce_hideword"),
    INTRODUCE_COMMENT(144, "图书介绍_写书评", "introduce_comment"),
    INTRODUCE_VOICE(145, "图书介绍_播放语音评论", "introduce_voice"),//1
    //    INTRODUCE_VOICE(146,"图书介绍_播放语音评论","introduce_voice"),//2
    INTRODUCE_MORE_COMMENT(147, "图书介绍_展开更多评论", "introduce_morecomment"),
    MORE_COMMENT(148, "展开更多评论页", "morecomment"),
    MORE_COMMENT_COMMENT(149, "更多评论_写书评", "morecomment_comment"),
    MORE_COMMENT_VOICE(150, "更多评论_播放语音评论", "morecomment_voice"),//1
    //    MORE_COMMENT_VOICE(151,"更多评论_播放语音评论","morecomment_voice"),//2
    MY(152, "我的", "my"),
    MY_PERSONAL(153, "我的_个人信息", "my_personal"),//1
    //    MY_PERSONAL(154,"我的_个人信息","my_personal"),//2
    MY_BABY(155, "我的_宝宝", "my_baby"),//1
    //    MY_BABY(156,"我的_宝宝","my_baby"),//2
//    MY_BABY(157,"我的_宝宝","my_baby"),//3
//    MY_BABY(158,"我的_宝宝","my_baby"),//4
    MY_COIN(159, "我的_咿啦币", "my_coin"),
    MY_RED_PACKET(160, "我的_红包", "my_redpacket"),
    MY_MEMBER(161, "我的_我的会员", "my_menber"),
    MY_EYE(162, "我的_护眼设置", "my_eye"),
    MY_EYE_INFO(163, "我的_护眼设置释义图标", "my_eyeinfo"),
    MY_EYE_CHOOSE(164, "我的_护眼设置时间选择", "my_eyechoose"),//1
    //    MY_EYE_CHOOSE(165,"我的_护眼设置时间选择","my_eyechoose"),//2
//    MY_EYE_CHOOSE(166,"我的_护眼设置时间选择","my_eyechoose"),//3
//    MY_EYE_CHOOSE(167,"我的_护眼设置时间选择","my_eyechoose"),//4
//    MY_EYE_CHOOSE(168,"我的_护眼设置时间选择","my_eyechoose"),//5
    MY_SET(169, "我的_设置", "my_set"),
    MY_ADVICE(170, "我的_信息反馈", "my_advice"),
    SET(171, "设置页", "set"),
    SET_BIND(172, "设置_账号绑定", "set_bind"),
    SET_RESET_CODE(173, "设置_重置密码", "set_resetcode"),
    SET_BUFFER(174, "设置_清除缓存", "set_buffer"),
    SET_WIFI(175, "设置_仅限wifi下载", "set_wifi"),//1
    //    SET_WIFI(176,"设置_仅限wifi下载","set_wifi"),//2
    SET_CHILD(177, "设置_默认进入儿童模式", "set_child"),//1
    //    SET_CHILD(178,"设置_默认进入儿童模式","set_child"),//2
    SET_EXIT(179, "设置_退出账号", "set_exit"),
    BIND(180, "账号绑定页", "bind"),
    BIND_PHONE(181, "账号绑定_手机账号去绑定", "bind_phone"),
    BIND_WECHAT(182, "账号绑定_微信账号去绑定", "bind_wechat"),
    BIND_QQ(183, "账号绑定_qq账号去绑定", "bind_qq"),
    BIND_WEIBO(184, "账号绑定_微博账号去绑定", "bind_weibo"),
    PHONE_BIND(185, "绑定手机号页", "phonebind"),
    PHONE_BIND_VERIFICATION(186, "绑定手机号_获取验证码", "phonebind_verification"),
    PHONE_BIND_NEXT(187, "绑定手机号_下一步", "phonebind_next"),
    RESET_CODE(188, "重置密码页", "resetcode"),
    RESET_CODE_VERIFICATION(189, "重置密码_获取验证码", "resetcode_verification"),
    RESET_CODE_CANCEL(190, "重置密码_取消", "resetcode_cancel"),
    RESET_CODE_DONE(191, "重置密码_完成", "resetcode_done"),
    ADVICE(192, "信息反馈页", "advice"),
    ADVICE_CANCEL(193, "信息反馈_取消", "advice_cancel"),
    ADVICE_SUBMIT(194, "信息反馈_提交", "advice_submit"),
    ADVICE_PICTURE(195, "信息反馈_添加照片", "advice_picture"),
    ADVICE_PICTURE_MANNER(196, "信息反馈_选择添加照片方式", "advice_picturemanner"),//1
    //    ADVICE_PICTURE_MANNER(197,"信息反馈_选择添加照片方式","advice_picturemanner"),//2
//    ADVICE_PICTURE_MANNER(198,"信息反馈_选择添加照片方式","advice_picturemanner"),//3
    ADVICE_CANCEL_PICTURE_MANNER(199, "信息反馈_取消选择添加照片方式", "advice_cancelpicturemanner"),
    PERSONAL(200, "个人信息页", "personal"),
    PERSONAL_PORTRAIT(201, "个人信息_头像", "personal_portrait"),
    PERSONAL_CHOOSE_PORTRAIT(202, "个人信息_添加头像方式", "personal_chooseportrait"),//1
    //    PERSONAL_CHOOSE_PORTRAIT(203,"个人信息_添加头像方式","personal_chooseportrait"),//2
//    PERSONAL_CHOOSE_PORTRAIT(204,"个人信息_添加头像方式","personal_chooseportrait"),//3
    PERSONAL_SAVE(205, "个人信息_保存", "personal_save"),
    BABY_READ(206, "宝宝阅读记录页", "babyread"),
    BABY_READ_CHANGE_BABY(207, "宝宝阅读记录_切换宝宝", "babyread_changebaby"),//1
    //    BABY_READ_CHANGEBABY(208,"宝宝阅读记录_切换宝宝","babyread_changebaby"),//2
//    BABY_READ_CHANGEBABY(209,"宝宝阅读记录_切换宝宝","babyread_changebaby"),//3
    BABY_READ_SAVE(210, "宝宝阅读记录_修改宝宝信息", "babyread_save"),
    BABY(211, "宝宝信息页", "baby"),
    BABY_SAVE(212, "宝宝信息_保存", "baby_save"),
    BABY_DELETE(213, "宝宝信息_删除宝宝", "baby_delete"),
    BABY_CHOOSE_PORTRAIT(214, "宝宝信息_添加头像方式", "baby_chooseportrait"),//1
    //    BABY_CHOOSE_PORTRAIT(215,"宝宝信息_添加头像方式","baby_chooseportrait"),//2
//    BABY_CHOOSE_PORTRAIT(216,"宝宝信息_添加头像方式","baby_chooseportrait"),//3
    CLASSIFY(217, "图书分类页", "classify"),
    CLASSIFY_FILTER(218, "图书分类_筛选条件下拉", "classify_filter"),
    CLASSIFY_CHOOSE_FILTER(219, "图书分类_选择某个筛选条件", "classify_choosefilter"),
    CLASSIFY_BOOK(220, "图书分类_点击某个绘本", "classify_book"),
    CHILD_HOME(221, "儿童模式首页", "childhome"),
    CHILD_HOME_VOICE(222, "儿童模式首页_声音图标", "childhome_voice"),//1
    //    CHILD_HOME_VOICE(223,"儿童模式首页_声音图标","childhome_voice"),//2
    CHILD_HOME_PARENT(224, "儿童模式首页_父母模式图标", "childhome_parent"),
    CHILD_HOME_BABY_STUDY(225, "儿童模式首页_宝宝书房", "childhome_babystudy"),
    CHILD_HOME_FAVORITE(226, "儿童模式首页_我的最爱", "childhome_favorite"),
    CHILD_HOME_RECENT(227, "儿童模式首页_最近阅读", "childhome_recent"),
    CHILD_HOME_BOUGHT(228, "儿童模式首页_刚刚购买", "childhome_bought"),
    CHILD_HOME_UNREAD(229, "儿童模式首页_好久未读", "childhome_unread"),
    CHILD_HOME_BABY(230, "儿童模式首页_宝宝信息", "childhome_baby"),
    CHILD_HOME_CHOOSE_BABY(231, "儿童模式首页_宝宝信息中切换宝宝", "childhome_choosebaby"),
//    CHILD_HOME_BABY_STUDY(232,"儿童模式宝宝书房页","childhomebabystudy"),

    CHILD_HOME_BABY_STUDY_TURN_PAGE(233, "儿童模式宝宝书房_左右划翻页", "childhomebabystudy_turnpage"),
    CHILD_HOME_BABY_STUDY_BOOK(234, "儿童模式宝宝书房_点击某个绘本", "childhomebabystudy_book"),
//    CHILD_HOME_FAVORITE(235,"儿童模式我的最爱页","childhomefavorite"),

    CHILD_HOME_FAVORITE_TURN_PAGE(236, "儿童模式我的最爱_左右划翻页", "childhomefavorite_turnpage"),
    CHILD_HOME_FAVORITE_BOOK(237, "儿童模式我的最爱_点击某个绘本", "childhomefavorite_book"),
//    CHILD_HOME_RECENT(238,"儿童模式最近阅读页","childhomerecent"),

    CHILD_HOME_RECENT_TURN_PAGE(239, "儿童模式最近阅读_左右划翻页", "childhomerecent_turnpage"),
    CHILD_HOME_RECENT_BOOK(240, "儿童模式最近阅读_点击某个绘本", "childhomerecent_book"),
//    CHILD_HOME_BOUGHT(241,"儿童模式刚刚购买页","childhomebought"),

    CHILD_HOME_BOUGHT_TURN_PAGE(242, "儿童模式刚刚购买_左右划翻页", "childhomebought_turnpage"),
    CHILD_HOME_BOUGHTT_BOOK(243, "儿童模式刚刚购买_点击某个绘本", "childhomeboughtt_book"),
//    CHILD_HOME_UNREAD(244,"儿童模式好久未读页","childhomeunread"),

    CHILD_HOME_UNREAD_TURN_PAGE(245, "儿童模式好久未读_左右划翻页", "childhomeunread_turnpage"),
    CHILD_HOME_UNREAD_BOOK(246, "儿童模式好久未读_点击某个绘本", "childhomeunread_book"),
    READ(247, "图书阅读页", "read"),
    READ_BUTTON_GROUP(248, "图书阅读_按钮组", "read_buttongroup"),
    READ_EXIT(249, "图书阅读_退出", "read_exit"),
    READ_SHARE(250, "图书阅读_分享", "read_share"),
    READ_PERUSAL(251, "图书阅读_选择精读模式", "read_perusal"),
    READ_PERUSAL_INTRODUCE(252, "图书阅读_精读模式介绍图标", "read_perusalintroduce"),
    READ_EXTENSIVE(253, "图书阅读_选择泛读模式", "read_extensive"),
    READ_EXTENSIVE_INTRODUCE(254, "图书阅读_泛读模式介绍图标", "read_extensiveintroduce"),
    READ_COMPLETE(255, "图书阅读完成", "read_complete"),
    READ_FLIP(256, "图书阅读_翻页图标", "read_flip"),//1
    //    READ_FLIP(257,"图书阅读_翻页图标","read_flip"),//2
//    READ_FLIP(258,"图书阅读_翻页图标","read_flip"),//3
    READ_SHARE_THIRD(259, "图书阅读_选择第三方分享方式", "read_sharethird"),//1
    //    READ_SHARE_THIRD(260,"图书阅读_选择第三方分享方式","read_sharethird"),//2
//    READ_SHARE_THIRD(261,"图书阅读_选择第三方分享方式","read_sharethird"),//3
//    READ_SHARE_THIRD(262,"图书阅读_选择第三方分享方式","read_sharethird"),//4
//    READ_SHARE_THIRD(263,"图书阅读_选择第三方分享方式","read_sharethird"),//5
//    READ_SHARE_THIRD(264,"图书阅读_选择第三方分享方式","read_sharethird"),//6
    READ_CLOSE_BUTTON_GROUP(265, "图书阅读_按钮组选择框关闭按钮", "read_closebuttongroup"),
    READ_LAST(266, "阅读最后页", "readlast"),
    READ_LAST_SHARE(267, "阅读最后页_分享", "readlast_share"),
    READ_LAST_SHARE_THIRD(268, "阅读最后页_选择第三方分享方式", "readlast_sharethird"),//1
    //    READ_LAST_SHARE_THIRD(269,"阅读最后页_选择第三方分享方式","readlast_sharethird"),//2
//    READ_LAST_SHARE_THIRD(270,"阅读最后页_选择第三方分享方式","readlast_sharethird"),//3
//    READ_LAST_SHARE_THIRD(271,"阅读最后页_选择第三方分享方式","readlast_sharethird"),//4
//    READ_LAST_SHARE_THIRD(272,"阅读最后页_选择第三方分享方式","readlast_sharethird"),//5
//    READ_LAST_SHARE_THIRD(273,"阅读最后页_选择第三方分享方式","readlast_sharethird"),//6
    READ_LAST_MY_COMMENT(274, "阅读最后页_我的评论", "readlast_mycomment"),
    READ_LAST_OTHER_COMMENT(275, "阅读最后页_精彩评论", "readlast_othercomment"),
    RECO_LIST(276, "图文推荐列表浏览人数", "reco_list"),
    RECO_DETAIL(277, "页面浏览", "reco_detail"),//图文 code
    RECO_BOOK(278, "图书推荐点击", "reco_book"),//图书 code
    DEVICE_NUM(279, "设备码", "device_num"),//设备码
    IP_ADDRESS(280, "IP 地址", "IP_address"),//地址
    BUY_BOOK_BUTTON(281, "introduce_buy", "buybook_button"),//图书 code
    BUY_BOOK_SUCCESS(282, "购买成功", "buybook_success"),//图书 code
    BUY_BOOK_OPEN(283, "已购买书籍被打开", "buybook_open"),//图书 code
    VIP_OPEN(284, "会员租赁书籍被打开", "vip_open"),//图书 code
    TIME_LIMIT_OPEN(285, "限时免费借阅书籍被打开", "timelimit_open"),//图书 code
    SEND_BOOK_OPEN(286, "送书书籍打开", "sendbook_open"),//图书 code
    CLASS_OPEN(287, "课程卡片-进入详情页", "class_open"),//课程code
    CLASS_PAY_SUCCESS(288, "购买按钮-购买成功", "class_paysuccess"),
    CLASS_PAY_FAIL(289, "购买按钮-购买失败", "class_payfail"),
    CLASS_REPORT_WINDOW(290, "查看成绩单", "class_reportwindow"),//用户ID
    //    CLASS_REPORT_WINDOW(291,"查看成绩单-查看成绩单页面","class_reportwindow"),
    CLASS_REPORT_BUTTON(292, "查看成绩单", "class_reportbutton"),//用户ID
//    DEVICE_NUM(293,"","device_num"),//设备码
//    IP_ADDRESS(294,"IP 地址","IP_address"),//地址

    LOG_IN_TIME(295, "登录时间", "login_time"),//用户ID
    VERSION_NUMBER(296, "APP版本号", "version_number"),//用户ID
    PLATFORM_TYPE(297, "平台渠道", "platform_type"),//渠道来源
    ID_LOCATE(298, "用户定位", "ID_locate"),//用户位置信息
    CHOOSE_SUM(299, "浏览量-下载后首次启动APP", "choose_sum"),
    CHOOSE_LOG(300, "点击登录数量-登录按钮", "choose_log"),
    CHOOSE_SIGN(301, "点击注册数量-注册按钮", "choose_sign"),
    CHOOSE_SHIP(302, "点击先逛逛数量-先逛逛按钮", "choose_ship"),
    CHOOSE_AGREEMENT(303, "点击用户协议数量-用户协议按钮", "choose_agreement"),
    SIGN_CODE_COMPLETE(304, "设置密码-完成-点击完成按钮", "sign_codecomplete"),
    SIGN_NEXT(305, "发送验证码成功", "sign_next"),//用户手机号
    FORGET_CODE_NEXT_NEW(306, "发送验证码成功-忘记密码点击下一步验证成功", "forgetcode_nextnew"),
    VERIFICATION_NEXT(307, "发送验证码成功-安全验证点击获取验证码成功", "verification_next"),
    BIND_NEXT(308, "发送验证码成功-绑定手机获取验证码成功", "bind_next"),
//    RESET_CODE_VERIFICATION(309,"发送验证码成功-修改密码获取验证码成功","resetcode_verification"),

    QUESTION_SHIP(310, "问题1", "question_ship"),//用户ID
    QUESTION_BOY(311, "问题1-男孩", "question_boy"),
    QUESTION_GIRL(312, "问题1-女孩", "question_girl"),
    QUESTION_02(313, "问题2-0-2", "question_02"),
    QUESTION_36(314, "问题2-3-6", "question_36"),
    QUESTION_710(315, "问题2-7-10", "question_710"),
    QUESTION_EQ(316, "问题3-情商管理", "question_eq"),
    QUESTION_HABIT(317, "问题3-行为习惯", "question_habit"),
    QUESTION_GROWTH(318, "问题3-励志成长", "question_growth"),
    QUESTION_MORALITY(319, "问题3-品格培育", "question_morality"),
    QUESTION_COMPLETE(320, "问题3-完成按钮", "question_complete"),
    QUESTION_SUCCESS(321, "领书页面", "question_success"),//领取图书code
    SHARE_THIRD_SHIP(322, "我是新用户按钮-点击我是新用户按钮", "sharethird_ship"),
    SHARE_THIRD_BIND(323, "完成绑定", "sharethird_bind"),//绑定账号ID
    GUIDE_STUDY(324, "点击书房", "guide_study"),
    GUIDE_STUDY_CLOSE(325, "关闭", "guide_studyclose"),
    GUIDE_MNC_CLOSE(326, "移动网络弹窗取消", "guide_MNCclose"),
    GUIDE_MNC_CONTINUE(327, "移动网络弹窗继续下载", "guide_MNCcontinue"),
    GUIDE_INTERRUPTION(328, "断网弹窗", "guide_interruption"),
    GUIDE_DOWNLOAD_SUCCESS(329, "下载成功", "guide_downloadsuccess"),
    GUIDE_DOWNLOAD_CLOSE(330, "关闭", "guide_downloadclose"),
    GUIDE_READ(331, "点击", "guide_read"),
    GUIDE_READ_CLOSE(332, "关闭", "guide_readclose"),
    GUIDE_BABY(333, "点击小火车", "guide_baby"),//下载触发的图书code
    GUIDE_BABY_CLOSE(334, "关闭", "guide_babyclose"),
    GUIDE_BABY_STUDY(335, "点击宝宝书房", "guide_babystudy"),
    GUIDE_BABY_STUDY_YES(336, "知道了", "guide_babystudyyes"),
    GUIDE_BABY_STUDY_CLOSE(337, "关闭", "guide_babystudyclose"),
    GUIDE_MY_TOURISTS(338, "游客引导关闭-去注册或登录", "guide_mytourists"),
    GUIDE_MY_TOURISTS_CLOSE(339, "游客引导关闭-手动关闭", "guide_mytouristsclose"),
    GUIDE_MY_BABY(340, "完善宝宝信息关闭-进入宝宝详情", "guide_mybaby"),
    GUIDE_MY_BABY_CLOSE(341, "完善宝宝信息关闭-点击关闭", "guide_mybabyclose"),
    GUIDE_MY_MEMBER(342, "会员引导-进入会员界面", "guide_mymember"),
    GUIDE_MY_MEMBER_CLOSE(343, "会员引导-点击关闭", "guide_mymemberclose"),
    STUDY_NEW_GROUP1(344, "新建分组-无分组时新建", "study_newgroup1"),
    STUDY_NEW_GROUP2(345, "新建分组-分组右上角文字按钮新建", "study_newgroup2"),
    STUDY_DELETE_GROUP(346, "删除分组", "study_deletegroup"),
    STUDY_DISSOLVE_GROUP(347, "解散分组", "study_dissolvegroup"),
    STUDY_NAMED_GROUP(348, "重命名分组", "study_namedgroup"),
    STUDY_LONG_PRESS(349, "触发选择模式-长按触发", "study_longpress"),
    STUDY_CHOOSE(350, "触发选择模式-快捷按钮触发", "study_choose"),
    STUDY_CHOOSE_DELETE(351, "触发后选择功能-删除", "study_choosedelete"),
    STUDY_CHOOSE_GROUP(352, "触发后选择功能-分组", "study_choosegroup"),
    STUDY_CHOOSE_DOWNLOAD(353, "触发后选择功能-下载", "study_choosedownload"),
    STUDY_FAST_GROUP(354, "一键分组按钮", "study_fastgroup"),
    STUDY_FAST_DELETE(355, "一键清空失效书籍按钮", "study_fastdelete"),
    STUDY_FAST_DOWNLOAD(356, "一键下载按钮", "study_fastdownload"),
    STUDY_RECYCLE(357, "回收站-回收站点击", "study_recycle"),
    STUDY_RECYCLE_SUCCESS(358, "回收站-回收站还原成功", "study_recyclesuccess"),
    RECYCLE_CHOOSE(359, "回收站删除书籍来源", "recycle_choose"),//图书code
    RECYCLE_GROUP(360, "回收站删除书籍来源-分组直接删除", "recycle_group"),
    RECYCLE_FAST_DELETE(361, "回收站删除书籍来源-一键清空", "recycle_fastdelete"),
    RECYCLE_DELETE(362, "回收站删除书籍来源-过期书籍点击删除", "recycle_delete"),
    UNLOCK_OPEN_MEMBER(363, "过期书籍选项", "unlock_openmember"),//图书code
    UNLOCK_USE_MEMBER(364, "过期书籍选项-点击使用会员身份解锁", "unlock_usemember"),
    UNLOCK_BUY(365, "过期书籍选项-点击购买", "unlock_buy"),
    UNLOCK_DELETE(366, "过期书籍选项-点击删除", "unlock_delete"),
    UNLOCK_SUCCESS_BUY(367, "过期书籍解锁成功-购买解锁成功", "unlocksuccess_buy"),
    UNLOCK_SUCCESS_OPEN_MEMBER(368, "过期书籍解锁成功-开通会员解锁成功", "unlocksuccess_openmember"),
    UNLOCK_SUCCESS_USE_MEMBER(369, "过期书籍解锁成功-通过会员身份解锁成功", "unlocksuccess_usemember"),
    ORDER_BOOK(370, "购买成功", "order_book"),//图书code
    ORDER_BOOK_GROUP(371, "购买成功", "order_bookgroup"),//图书包ID
    ORDER_CLASS(372, "购买成功", "order_class"),//课程code
    ORDER_COIN(373, "购买成功", "order_coin"),//咿啦币数量
    ORDER_MEMBER(374, "购买成功", "order_member"),//会员类型
    READ_PLAN(375, "退出阅读器", "read_plan"),//图书code
    SEARCH_KEYWORD(376, "热门搜索关键字", "search_keyword"),//关键字用从1开始的后缀区分
    SEARCH_HOT_SEARCH(377, "点击热门搜索关键字-点击任意一个关键字触发搜索记为一次", "search_hotsearch"),
    STUDY_STOP_DOWNLOAD(378, "批量下载终止按钮-不等了按钮", "study_stopdownload"),
    STUDY_WAIT_DOWNLOAD(379, "批量下载终止按钮-耐心等待按钮", "study_waitdownload"),
    STUDY_SERIES(380, "下拉展示", "study_series"),//手动下拉一次记一次，不包含书房加载触发的
    SERIES_CLICK(381, "点击系列图标", "series_click"),
    SERIES_FIRST(382, "点亮第一个系列引导提示", "series_first"),
    SERIES_COMPLETE(383, "第一个全部收集系列引导提示", "series_complete"),
    SERIES_DISAPPEAR(384, "第一次熄灭系列引导提示", "series_disappear"),
    PAY_ALL(385, "查看全部", "pay_all"),
    PAY_VIP(386, "开通会员", "pay_vip"),
    PAY_COUPONS(387, "购书红包-选择可用红包并成功折扣", "pay_coupons"),
    PAY_VIP_RENT(388, "成功快速开通会员（弹出成功弹窗）-“好的”按钮", "pay_viprent"),
    PAY_VIP_CANCEL(389, "成功快速开通会员（弹出成功弹窗）-“再看看”按钮", "pay_vipcancel"),
    RECHARGE_PAY(390, "快速充值咿啦币", "recharge_pay"),//商品code
    PAY_CONFIRM_PAY(391, "确认支付", "pay_confirmpay"),//商品code
    PAY_SUCCESS_STUDY(392, "支付成功页-前往书房", "paysuccess_study"),
    PAY_SUCCESS_BACK(393, "支付成功页-返回", "paysuccess_back"),
    LOG_FAST_LOG(394, "账号登录", "logfast_log"),
    LOG_FAST_SIGN(395, "前往注册", "logfast_sign"),
    LOG_LOG_FAST(396, "快捷登录", "log_logfast"),
    LOG_FAST_VERIFICATION(397, "发送成功-快捷登录", "logfast_verification"),
    EXIT_VERIFICATION(398, "发送成功-注销设置密码", "exit_verification"),
    EXIT_SHIP(399, "建议设置密码-跳过", "exit_ship"),
    EXIT_PASSWORD(400, "建议设置密码-设置密码完成", "exit_password");

    private int id;
    private String eventName;
    private String eventId;

    public static String findEventName(Object obj) {
        if (obj == null) {
            return null;
        }
        for (AppLogsEventEnum appLogsEventEnum : AppLogsEventEnum.values()) {
            if (Objects.equals(appLogsEventEnum.getEventId(), obj.toString())) {
                return appLogsEventEnum.getEventName();
            }
        }
        return null;
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getEventName() {
        return eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public String getEventId() {
        return eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }
}
