package com.ellabook.constraint.inf.impl;


import com.ellabook.constraint.annotation.DefaultLength;
import com.ellabook.constraint.annotation.DefaultURL;
import com.ellabook.constraint.inf.SetDefault;

import javax.validation.ConstraintViolation;

/**
 * Set default {@link String} value for {@Code field} annotated by {@link DefaultLength}
 */
public class SetValidURLDefault implements SetDefault<DefaultURL, String> {

    @Override
    public <B> void setDefault(ConstraintViolation<B> tConstraintViolation, DefaultURL annotation) throws Exception {
        String value = annotation.value();
        invokeSetFieldValue(tConstraintViolation, value);
    }

    @Override
    public Class<DefaultURL> getAnnotation() {
        return DefaultURL.class;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
    }


}
