package com.ellabook.constraint.inf.impl;

import com.ellabook.constraint.annotation.DefaultCode;
import com.ellabook.constraint.annotation.DefaultString;
import com.ellabook.constraint.inf.SetDefault;
import com.ellabook.util.CoreUtil;
import org.apache.poi.ss.formula.functions.T;

import javax.validation.ConstraintViolation;
import java.lang.reflect.Method;

/**
 * Set default {@link String} value for {@Code field} annotated by {@link DefaultCode}
 */
public class SetDefaultCode implements SetDefault<DefaultCode, String> {

    @Override
    public <B> void setDefault(ConstraintViolation<B> tConstraintViolation, DefaultCode annotation) throws Exception {

        Object util = annotation.classUtil().newInstance();
        String methodName = annotation.method();
        String prefix = annotation.prefix();
        int suffix = annotation.suffix();
        String value;
        if (util instanceof CoreUtil && "createCommonsCore".equals(methodName)) {
            Method method = util.getClass().getMethod(methodName, String.class, int.class);
            value = (String) method.invoke(util, prefix, suffix);
        } else {
            Method method = util.getClass().getMethod(methodName);
            value = (String) method.invoke(util);
        }

        invokeSetFieldValue(tConstraintViolation, value);
    }

    @Override
    public Class<DefaultCode> getAnnotation() {
        return DefaultCode.class;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
    }
}
