package com.ellabook.aspect;

import com.ellabook.util.redis.RedisServiceUtil;
import com.ellabook.util.redis.RedisZone;
import com.ellabook.util.redis.RedisZoneEnum;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class RedisAspect {
    @Pointcut("@annotation(com.ellabook.util.redis.RedisZone)")
    public void redisPointcut() {
    }

    @Around("redisPointcut()")
    public Object Interceptor(ProceedingJoinPoint joinPoint) throws Throwable {
        LinkedHashMap<RedisServiceUtil, Integer> map = new LinkedHashMap<>();
        try {
            Object obj = joinPoint.getTarget();
            Class<?> clz = obj.getClass();
            Field[] fields = clz.getDeclaredFields();
            for (int i = 0; fields != null && i < fields.length; i++) {
                Field field = fields[i];
                field.setAccessible(true);
                Object fieldObj = field.get(obj);
                if (fieldObj instanceof RedisServiceUtil) {
                    RedisServiceUtil redis = (RedisServiceUtil) fieldObj;
                    map.put(redis, redis.getDatabase());
                    Method method = ((MethodSignature) joinPoint.getSignature()).getMethod();
                    RedisZone redisZone = method.getAnnotation(RedisZone.class);
                    redisZone = redisZone == null ? field.getAnnotation(RedisZone.class) : redisZone;
                    redisZone = redisZone == null ? clz.getAnnotation(RedisZone.class) : redisZone;
                    if (redisZone != null) {
                        method = redis.getClass().getSuperclass().getDeclaredMethod("setDatabase", RedisZoneEnum.class);
                        method.setAccessible(true);
                        method.invoke(redis, redisZone.value());
                    }
                }
            }
            Object proceed = joinPoint.proceed(joinPoint.getArgs());
            return proceed;
        } catch (Throwable e) {
            throw e;
        } finally {
            Iterator<Map.Entry<RedisServiceUtil, Integer>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<RedisServiceUtil, Integer> next = iterator.next();
                RedisServiceUtil redis = next.getKey();
                Method method = redis.getClass().getSuperclass().getDeclaredMethod("setDatabase", RedisZoneEnum.class);
                method.setAccessible(true);
                method.invoke(redis, RedisZoneEnum.getRedisZoneEnum(next.getValue()));
            }
        }
    }

}

