package com.ellabook.aspect;

import com.alibaba.fastjson.JSONObject;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;

import java.lang.reflect.Method;

public class PrimaryKeyHelper {

    public String getPrimaryKey(ProceedingJoinPoint joinPoint) {
        Method method = ((MethodSignature) joinPoint.getSignature()).getMethod();
        String[] primaryKey = method.getAnnotation(AvoidConcurrent.class).primaryKey();
        JSONObject object = JSONObject.parseObject(joinPoint.getArgs()[0].toString());
        StringBuilder sb = new StringBuilder();
        for (String item : primaryKey) {
            sb.append(object.getString(item));
        }
        return sb.toString();
    }

}