package com.ellabook.aspect;

import com.ellabook.exception.EllaBookException;
import com.ellabook.util.ResponseParamsUtil;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;

public abstract class ExceptionAspect {
    private ResponseParamsUtil res = new ResponseParamsUtil();

    public abstract void exceptionPointcut();

    @Around("exceptionPointcut()")
    public Object Interceptor(ProceedingJoinPoint joinPoint) {
        try {
            return joinPoint.proceed(joinPoint.getArgs());
        } catch (EllaBookException e) {
            e.printStackTrace();
            return e.getResponseParams();
        } catch (Throwable e) {
            e.printStackTrace();
            return res.fail("000000", "服务请求繁忙，请稍后重试", "0");
        }
    }

}

