package com.ellabook.aspect;

import com.alibaba.fastjson.JSONObject;
import com.ellabook.util.doc.*;
import com.ellabook.util.doc.annotations.DocConfig;
import com.ellabook.util.doc.enums.EllaProject;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

import java.io.File;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;

/**
 * @author mc
 * @date 2018/7/12
 */
public class DocAspect {
    private final static SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    protected static String projectName;
    protected static EllaProject ellaProject;

    @Pointcut("@annotation(com.ellabook.util.doc.annotations.DocConfig)")
    public void docPointcut() {
    }

    @Around("docPointcut()")
    public Object Interceptor(final ProceedingJoinPoint joinPoint) throws Throwable {
        Object response = joinPoint.proceed(joinPoint.getArgs());
        writeDoc(joinPoint, response);
        return response;
    }

    private void writeDoc(ProceedingJoinPoint joinPoint, Object response) {
        Thread thread = new Thread() {
            public void run() {
                try {
                    String project = StringUtils.isNotBlank(projectName) ? (projectName + File.separator) : "";
                    Object obj = joinPoint.getTarget();
                    Class<?> clz = obj.getClass();
                    Method method = ((MethodSignature) joinPoint.getSignature()).getMethod();
                    DocConfig docConfig = method.getAnnotation(DocConfig.class);
                    if (expire(format.parse(docConfig.expireFlag()))) return;
                    Object o /*= joinPoint.getArgs()[0]*/;
                    if (joinPoint.getArgs().length < 1) {
                        o = "{}";
                    } else {
                        o = joinPoint.getArgs()[0];
                    }
                    JSONObject param /*= JSONObject.parseObject(o == null || o instanceof String ? "{}" : o.toString())*/;
                    if (o == null) {
                        o = "{}";
                    }
                    if (o instanceof String) {
                        try {
                            param = JSONObject.parseObject(o.toString());
                        } catch (Exception e) {
                            param = new JSONObject();
                        }
                    } else {
                        param = JSONObject.parseObject(JSONObject.toJSONString(o));
                    }
                    if (docConfig != null) {
                        DocEntity doc = docConfig.developer().get().setInfDesc(getNestedProperty(response, "remark"))
                                .setMethod((getNestedProperty(param, "publicParam.method")));
                        setErrorExample(docConfig, doc);
                        DocFactory docUtil = DocFactory.instance().setEllaProject(ellaProject)
                                .setParamAndResponse(param, response).setParamAndResponseClz(docConfig.VO(), docConfig.DTO())
                                .setDocAndFileName(doc, (project + clz.getTypeName() + File.separator + method.getName()));
                        docUtil.create(docConfig.type());
                    }
                } catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        };
        thread.start();
    }

    private boolean expire(Date expire) {
        Calendar cl = Calendar.getInstance();
        cl.set(Calendar.MINUTE, 0);
        cl.set(Calendar.SECOND, 0);
        cl.add(Calendar.HOUR, -2);
        Date startTime = cl.getTime();
        cl.add(Calendar.HOUR, 4);
        Date endTime = cl.getTime();
        if (expire.before(startTime) || expire.after(endTime)) {
            return true;
        }
        return false;
    }

    private void setErrorExample(DocConfig docConfig, DocEntity doc) {
        String[] error = docConfig.error();
        if (error != null && error.length > 0) {
            for (int i = 0; i < error.length; i++) {
                if (StringUtils.isNotBlank(error[i])) {
                    String[] split = error[i].split(":");
                    if (split.length > 1) {
                        Map<String, String> map = doc.getErrorCodeAndMessage();
                        map.put(split[0], split[1]);
                    }
                }
            }
        }
    }

    public String getNestedProperty(Object object, String item) {
        try {
            return BeanUtils.getNestedProperty(object, item);
        } catch (Exception e) {
            return "";
        }
    }
}
