package com.constants;

public interface BookRedisConstantUtil {


    /**
     * 图书
     */
    String REDIS_BOOK_CODE = "BOOK:CODE:";
    /**
     * 出版社
     */
    String REDIS_PRESS_CODE = "PRESS:CODE:";
    /**
     * 图书详情
     */
    String REDIS_BOOK_DETAILS = "BOOK:DETAILS:";
    /**
     * 图书原作者名字
     */
    String REDIS_BOOK_ORIGINAUTHOR_NAMES = "BOOK:ORIGINAUTHOR:NAMES:";
    /**
     * 图书封面资源
     */
    String REDIS_BOOK_PREVIEW_RESOURCE = "BOOK:RESOURCE:PREVIEW:";
    /**
     * 图书预览资源
     */
    String REDIS_BOOK_COVER_RESOURCE = "BOOK:RESOURCE:COVER:";
    /**
     * 图书阅读资源
     */
    String REDIS_BOOK_FORMAL_RESOURCE = "BOOK:RESOURCE:FORMAL:";
    /**
     * 图书阅读资源
     */
    String REDIS_BOOK_TEACHING_MODE_RESOURCE = "BOOK:RESOURCE:TEACHING:";
    /**
     * 图书阅读资源
     */
    String REDIS_BOOK_LISTEN_RESOURCE = "BOOK:RESOURCE:TEACHING:";

    String BOE_STUDY_BOOKS_NORMAL_INFO = "BOE:STUDY:NORMALBOOKSINFO:";
    String BOE_STUDY_BOOKS_IPHONE2208_INFO = "BOE:STUDY:IPHONE2208BOOKSINFO:";


    /**
     * 首页专题
     */
    String REDIS_INDEX_SUBJECT = "INDEX:SUBJECT:";
    /**
     * 首页栏目
     */
    String REDIS_INDEX_PART = "INDEX:PART:";
    /**
     * 首页每日推荐
     */
    String REDIS_INDEX_PART_DAILY = "INDEX:PART:DAILY:";
    /**
     * 首页栏目
     */
    String REDIS_INDEX_PART_2_0_7 = "INDEX:PART:2.0.7:";
    /**
     * 首页栏目-课程推荐
     */
    String REDIS_INDEX_PART_2_2_3 = "INDEX:PART:2.2.3:";
    /**
     * 高级会员专区
     */
    String REDIS_INDEX_PART_2_2_7 = "INDEX:PART:2.2.7:";
    /**
     * 首页栏目-图书专题
     */
    String REDIS_INDEX_PART_2_4_8 = "INDEX:PART:2.4.8:";

    /**
     * 首页栏目-课程推荐
     */
    //String REDIS_INDEX_PART_2_2_1 = "INDEX:PART:2.2.1:";
    /**
     * 首页banner
     */
    String REDIS_INDEX_BANNER = "INDEX:BANNER:";
    /**
     * 首页栏目信息
     */
    String REDIS_INDEX_PART_ALL = "INDEX:PART:ALL:";
    /**
     * 首页栏目信息
     */
    String REDIS_INDEX_PART_ALL_2_0_7 = "INDEX:PART:ALL:2.0.7:";
    /**
     * 首页栏目信息-课程推荐
     */
    String REDIS_INDEX_PART_ALL_2_2_3 = "INDEX:PART:ALL:2.2.3:";
    /**
     * 首页栏目信息- 新增高级会员
     */
    String REDIS_INDEX_PART_ALL_2_2_7 = "INDEX:PART:ALL:2.2.7:";
    /**
     * 首页栏目信息-课程推荐
     */
    //String REDIS_INDEX_PART_ALL_2_2_1 = "INDEX:PART:ALL:2.2.1:";
    /**
     * 首页栏目-图书专题
     */
    String REDIS_INDEX_PART_ALL_2_4_8 = "INDEX:PART:ALL:2.4.8:";


    /**
     * 超出百分比
     */
    String REDIS_SURPASS_RATE = "SURPASS:RATE:";
    /**
     * 父母超出百分比
     */
    String REDIS_SURPASS_PARENT_RATE = "SURPASS:PARENT:RATE:";
    /**
     * 百科分类
     */
    String REDIS_BOOK_WIKI = "BOOK:WIKI:";

    /*************************************** USER *************************************/
    /**
     * key:token value:用户的uid
     */
    String REDIS_USER_OPEN_ID = "USER:OPENID:";
    /**
     * key:token value:用户的uid
     */
    String REDIS_USER_TOKEN = "USER:TOKEN:";


    /**
     * 引领右脑key
     */
    String REDIS_YOU_NAO_USER = "USER:YOU_NAO:UID";
    String REDIS_YOU_NAO_BOOK = "BOOK:YOU_NAO:BOOK_CODE:";

    /**
     * key:uid value:用户的token
     */
    String REDIS_OPERATION_USER_TOKEN = "USER:OPERATION:TOKEN:";
    /**
     * key:用户的uid value:（code码+设备码+message）
     */
    String REDIS_USER_TOKEN_INFO = "USER:TOKEN:INFO:";
    /**
     * 当前用户的账号信息（QQ+WEIXIN+SINA+phone）
     */
    String USER_LOGIN_INFO = "USER:LOGIN:INFO:";
    /**
     * key:设备码 value:在该设备最近登录用户的uid
     */
    String REDIS_USER_DEVICE_NO = "USER:DEVICE:NO:";
    /**
     * key:手机号 value:验证码
     */
    String REDIS_MOBILE_CODE = "MOBILE:CODE:";
    /*************************************** 首页推荐广告 *************************************/

    /**
     * search下拉缓存
     */
    String REDIS_OPERATION_SEARCH_GROUPID = "OPERATION:SEARCH:GROUPID:";

    /**
     * 国内站点APP：search下拉缓存
     */
    String REDIS_OPERATION_SEARCH_GROUPID_CN_APP = "OPERATION:SEARCH:GROUPID:CN:APP:";
    /**
     * 国内站点BOE：search下拉缓存
     */
    String REDIS_OPERATION_SEARCH_GROUPID_CN_BOE = "OPERATION:SEARCH:GROUPID:CN:BOE:";

    /**
     * 国际站点APP：search下拉缓存
     */
    String REDIS_OPERATION_SEARCH_GROUPID_OTHER_APP = "OPERATION:SEARCH:GROUPID:OTHER:APP:";
    /**
     * 国际站点BOE：search下拉缓存
     */
    String REDIS_OPERATION_SEARCH_GROUPID_OTHER_BOE = "OPERATION:SEARCH:GROUPID:OTHER:BOE:";

    /**
     * 广告横幅search下拉缓存
     */
    String REDIS_OPERATION_SEARCH_GROUPID_AD = "OPERATION:SEARCH:GROUPID_AD:";

    /***************************************USER*************************************/
    String REDIS_HOME_MOBILE_CODE = "HOME:MOBILE:CODE:";
    String REDIS_HOME_MENU = "HOME:MENU:";

    String REDIS_EMAIL_CODE_LOGIN = "EMAIL:CODE:LOGIN:";

    String DISTRIBUTED_HIGH_CONCURRENCY_REGISTER_CHECK = "USER:DISTRIBUTED_HIGH_CONCURRENCY_REGISTER:";

    String DISTRIBUTED_HIGH_CONCURRENCY_PACKING_CHECK = "BOOK:DISTRIBUTED_HIGH_CONCURRENCY_PACKING_CHECK:";
    /**
     * 用户注册状态
     */
    String USER_REGISTER_STATUS = "USER:REGISTER_STATUS:";
    /**
     * 积分广告
     */
    String REDIS_POINT_AD = "POINT:AD:";
    /**
     * IP地址关联信息
     */
    String COUNTRY_IP_ADDRESS = "COUNTRY:IP:ADDRESS:";
    /*************************************** 配置信息 *************************************/
    String REDIS_CONFIG_USER_CARD = "CONFIG:USER:CARD:";
    String REDIS_CONFIG_USER_COIN = "CONFIG:USER:COIN:";

    /*************************************** 商品信息*************************************/
    String REDIS_GOODS = "GOODS:";
    Long REDIS_GOODS_EXPIRE_TIME = 24 * 60 * 60L;

    /*************************************** 闪屏广告 *************************************/
    String REDIS_STARTUP_AD = "STARTUP:AD:";

    /**
     * 教学模式 key:bookCode
     */
    /**
     * 教学模式详情
     */
    String REDIS_TEACHING_MODE_INFO = "TEACHING_MODE:INFO:";
    /**
     * 编辑教学模式当前页的用户
     */
    String REDIS_TEACHING_MODE_INFO_EDITEBY = "TEACHING_MODE:INFO:BEINGEDITEDBY:";
    /**
     * 教学模式的过期时间
     */
    long REDIS_TEACHING_MODE_INFO_EXPIRE = 3600;
    /**
     * 教学模式当前页的权限token
     */
    String REDIS_TEACHING_MODE_HTML_TOKEN = "TEACHING_MODE:HTML:TOKEN:";
    /**
     * 教学模式当前的状态：只读，可读可写
     */
    String REDIS_TEACHING_MODE_HTML_STATUS = "TEACHING_MODE:HTML:STATUS:";
    /**
     * 教学模式当前是否为只读状态
     */
    String REDIS_TEACHING_MODE_HTML_READ_ONLY = "TEACHING_MODE:HTML:READ:ONLY:";
    /**
     * 教学模式当前是否为只读状态的过期时间
     */
    long REDIS_TEACHING_MODE_HTML_READ_ONLY_EXPIRE = 60;
    /**
     * 打包进度
     */
    String REDIS_TEACHING_MODE_PACKAGE_PERCENT = "TEACHING_MODE:PACKAGE:PERCENT:";
    long REDIS_TEACHING_MODE_PACKAGE_PERCENT_EXPIRE = 60;
    /**
     * response对象
     */
    String REDIS_TEACHING_MODE_PACKAGE_RESPONSE = "TEACHING_MODE:PACKAGE:RESPONSE:";
    long REDIS_TEACHING_MODE_PACKAGE_RESPONSE_EXPIRE = 60;
    /**
     * 打包记录
     */
    String REDIS_TEACHING_MODE_PACKAGE_RECORD = "TEACHING_MODE:PACKAGE:RECORD:";
    /**
     * 用于计算百分比进度的毫秒值
     */
    String REDIS_TEACHING_MODE_PACKAGE_PERCENT_INCR = "TEACHING_MODE:PACKAGE:PERCENT:INCR:";
    /**
     * 打包已进行到的阶段
     */
    String REDIS_TEACHING_MODE_PACKAGE_STAGE = "TEACHING_MODE:PACKAGE:STAGE:";
    /**
     * 当前图书教学模式打包总耗时
     */
    String REDIS_TEACHING_MODE_PACKAGE_TIME_CONSUMING = "TEACHING_MODE:PACKAGE:TIMECONSUMING:";
    /**
     * 当前教模式的打包人
     */
    String REDIS_TEACHING_MODE_PACKAGE_PACKINGBY = "TEACHING_MODE:PACKAGE:PACKINGBY:";

    /**
     * 启动弹窗
     */
    String REDIS_ADVICE_STARTUP_POPUP = "ADVICE:STARTUP:POPUP:";
    /**
     * 闪屏广告
     */
    String REDIS_ADVICE_SPLASH_AD = "ADVICE:SPLASH:AD:";
    /**
     * 系统弹窗
     */
    String REDIS_ADVICE_SYSTEM_POPUP = "ADVICE:SYSTEM:POPUP:";
    /**
     * iOS测试设备友盟token列表
     */
    String REDIS_APP_PUSH_IOS_TEST_DEVICE_TOKEN_LIST = "APP:PUSH:IOS_TEST_DEVICE_TOKEN_LIST";
    /**
     * android测试设备友盟token列表
     */
    String REDIS_APP_PUSH_ANDROID_TEST_DEVICE_TOKEN_LIST = "APP:PUSH:ANDROID_TEST_DEVICE_TOKEN_LIST";


    /**
     * 首页定时推送
     */
    /**
     * 首页的下次推送时间（APP）
     */
    String REDIS_OPERATION_INDEX_PAGE_NEXT_PUBLISH_TIME = "PUBLISH:INDEX:PAGE:NEXT_PUBLISH_TIME";
    /**
     * 首页的下次推送时间（APP_OTHER）
     */
    String REDIS_OPERATION_INDEX_PAGE_NEXT_PUBLISH_TIME_OTHER = "PUBLISH:INDEX:PAGE:NEXT_PUBLISH_TIME_OTHER";

    /**
     * 首页的下次推送时间（BOE）
     */
    String REDIS_OPERATION_INDEX_PAGE_NEXT_PUBLISH_TIME_BOE = "PUBLISH:INDEX:PAGE:NEXT:PUBLISH:TIME:BOE";
    /**
     * 首页的下次推送时间（HD）
     */
    String REDIS_OPERATION_INDEX_PAGE_NEXT_PUBLISH_TIME_HD = "PUBLISH:INDEX:PAGE:NEXT_PUBLISH_TIME_HD";

    /**
     * 首页的下次推送时间（HD_OTHER）
     */
    String REDIS_OPERATION_INDEX_PAGE_NEXT_PUBLISH_TIME_HD_OTHER = "PUBLISH:INDEX:PAGE:NEXT_PUBLISH_TIME_HD_OTHER";
    /**
     * 首页的下次推送时间（GUSHIJI）
     */
    String REDIS_OPERATION_INDEX_PAGE_NEXT_PUBLISH_TIME_GUSHIJI = "PUBLISH:INDEX:PAGE:NEXT_PUBLISH_TIME_GUSHIJI";

    /**
     * 不用了
     **/
    String REDIS_OPERATION_INDEX_PAGE_PUBLISH_TIME = "PUBLISH:HOME:PAGE:UPDATETIME";

    /**
     * 首页定时推送更新时间（APP）
     */
    String REDIS_OPERATION_INDEX_PAGE_PUBLISH_TIME_APP = "PUBLISH:HOME:PAGE:UPDATETIME_APP";
    /**
     * 首页定时推送更新时间（APP_OTHER）
     */
    String REDIS_OPERATION_INDEX_PAGE_PUBLISH_TIME_APP_OTHER = "PUBLISH:HOME:PAGE:UPDATETIME_APP_OTHER";
    /**
     * 首页定时推送更新时间（HD）
     */
    String REDIS_OPERATION_INDEX_PAGE_PUBLISH_TIME_HD = "PUBLISH:HOME:PAGE:UPDATETIME_HD";
    /**
     * 首页定时推送更新时间（HD_OTHER）
     */
    String REDIS_OPERATION_INDEX_PAGE_PUBLISH_TIME_HD_OTHER = "PUBLISH:HOME:PAGE:UPDATETIME_HD_OTHER";
    /**
     * 首页定时推送更新时间（GUSHIJI）
     */
    String REDIS_OPERATION_INDEX_PAGE_PUBLISH_TIME_GUSHIJI = "PUBLISH:HOME:PAGE:UPDATETIME_GUSHIJI";
    /**
     * 首页推送更新时间（BOE）
     */
    String REDIS_OPERATION_INDEX_PAGE_PUBLISH_TIME_BOE = "PUBLISH:HOME:PAGE:UPDATETIME:BOE";

    /**
     * 个人中心发布时间 + 渠道
     */
    String REDIS_OPERATION_PERSONAL_PUBLISH_TIME = "PUBLISH:PERSONAL:UPDATETIME_";


    String REDIS_BOOK_PREVIEW_RESOURCE_VIDEO_FILE = "BOOK_PREVIEW_RESOURCE:VIDEO_FILE:";
    /**
     * 图书视频预览资源
     * <p>
     * <p>
     * /**
     * 数据统计 咿啦看书
     */
    String REDIS_ANALYSIS_DASHBOARD = "ANALYSIS:DATA:DASHBOARD:";
    String REDIS_ANALYSIS_DASHBOARD_SIMPLE = "ANALYSIS:DATA:DASHBOARD:SIMPLE";
    String REDIS_ANALYSIS_DASHBOARD_ACTUAL = "ANALYSIS:DATA:ACTUAL:DASHBOARD:";
    String REDIS_ANALYSIS_DAILY_DATA_ACTUAL = "ANALYSIS:DATA:ACTUAL:DAILY:";
    /**
     * key:token value:用户的uid
     */
    String REDIS_ANALYSIS_USER_TOKEN = "ANALYSIS:USER:TOKEN:";
    /**
     * key:token value:用户的uid
     */
    String REDIS_ANALYSIS_USER_PRODUCT = "ANALYSIS:USER:PRODUCT:";
    /**
     * key:用户的uid value:（权限菜单）
     */
    String REDIS_ANALYSIS_USER_TOKEN_INFO = "ANALYSIS:USER:TOKEN:INFO:";
    /**
     * ANALYTIC DB 缓存表
     */
    String REDIS_ANALYSIS_ANALYTIC_CACHE = "ANALYSIS:ANALYTIC:CACHE:";
    /**
     * 应用总览
     */
    String REDIS_ANALYSIS_SYNOPSIS = "ANALYSIS:DATA:SYNOPSIS:";
    /**
     * 应用总览详情
     */
    String REDIS_ANALYSIS_SYNOPSIS_DETAIL = "ANALYSIS:DATA:SYNOPSIS:DETAIL:";
    /**
     * 应用总览详情CHANNEL
     */
    String REDIS_ANALYSIS_SYNOPSIS_DETAIL_CHANNEL = "ANALYSIS:DATA:SYNOPSIS:DETAIL:CHANNEL:";
    /**
     * 应用总览时间段
     */
    String REDIS_ANALYSIS_SYNOPSIS_TIME_SLOT = "ANALYSIS:DATA:SYNOPSIS:TIME:SLOT:";
    /**
     * 应用总览top渠道
     */
    String REDIS_ANALYSIS_SYNOPSIS_TOP_CHANNEL = "ANALYSIS:DATA:SYNOPSIS:TOP:CHANNEL:";
    /**
     * 应用总览地域启动
     */
    String REDIS_ANALYSIS_SYNOPSIS_AREA_START = "ANALYSIS:DATA:SYNOPSIS:AREA:START:";
    /**
     * 应用总览留存
     */
    String REDIS_ANALYSIS_SYNOPSIS_REMAIN = "ANALYSIS:DATA:SYNOPSIS:REMAIN:";
    /**
     * 用户趋势-新增用户
     */
    String REDIS_ANALYSIS_USERTRENDS_ADDUSER = "ANALYSIS:DATA:USERTRENDS:ADDUSER:";
    /**
     * 用户趋势-付费用户
     */
    String REDIS_ANALYSIS_USERTRENDS_PAYUSER = "ANALYSIS:DATA:USERTRENDS:PAYUSER:";
    /**
     * 用户趋势-启动用户
     */
    String REDIS_ANALYSIS_USERTRENDS_STARTUSER = "ANALYSIS:DATA:USERTRENDS:STARTUSER:";
    /**
     * 数据统计 动画绘本馆
     */
    String REDIS_ANALYSIS_ELLAHOME_DASHBOARD = "ANALYSIS:ELLAHOME:DASHBOARD:";
    String REDIS_ANALYSIS_ELLAHOME_ACTIVE_USER = "ANALYSIS:ELLAHOME:DASHBOARD:ACTIVE:USER";
    String REDIS_ANALYSIS_ELLAHOME_ACTIVE_USER_HISTORY = "ANALYSIS:ELLAHOME:DASHBOARD:ACTIVE:USER:HISTORY";
    String REDIS_ANALYSIS_ELLAHOME_ACTIVE_USER_CURRENT = "ANALYSIS:ELLAHOME:DASHBOARD:ACTIVE:USER:CURRENT ";
    String REDIS_ANALYSIS_ELLAHOME_PARTNER_INCREASE_USER = "ANALYSIS:ELLAHOME:PARTNER:INCREASE:USER:";
    String REDIS_ANALYSIS_ELLAHOME_PARTNER_INCREASE_PAY = "ANALYSIS:ELLAHOME:PARTNER:INCREASE:PAY:";


    /*
     * 活跃用户
     */
    /**
     * 活跃用户历史数据
     * String REDIS_ANALYSIS_ACTIVE_HISTORY = "ANALYSIS:DATA:ACTIVE:HISTORY:";
     * /**
     * 活跃用户用户数据
     */
    String REDIS_ANALYSIS_ACTIVE = "ANALYSIS:DATA:ACTIVE:";
    /**
     * 活跃用户时间段
     */
    String REDIS_ANALYSIS_ACTIVE_TIME_SLOT = "ANALYSIS:DATA:ACTIVE:TIME:SLOT:";
    /**
     * 活跃用户每日列表
     */
    String REDIS_ANALYSIS_ACTIVE_DAILY_LIST = "ANALYSIS:DATA:ACTIVE:DAILY:LIST:";

    long REDIS_ANALYSIS_SYNOPSIS_EXPIRE_TIME = 60 * 60 * 24;
    long REDIS_ANALYSIS_SYNOPSIS_USER_DATA_EXPIRE_TIME = 5 * 60;
    long APP_LB_DATA_EXPIRE_TIME = 60;


    /**
     * 资源大小字节数
     */
    String REDIS_BOOK_MODE_RESOURCE_BYTES = "BOOK:RESOURCE:BYTES:FORMAL:";
    long REDIS_BOOK_MODE_RESOURCE_BYTES_EXPIRE_TIME = 60 * 60 * 24 * 7;

    String REDIS_TEACHING_MODE_RESOURCE_BYTES = "BOOK:RESOURCE:BYTES:TEACHING:FORMAL:";
    long REDIS_TEACHING_MODE_RESOURCE_BYTES_EXPIRE_TIME = 60 * 60 * 24 * 7;

    /**
     * 数据分析Redis有效期时间
     */
    long REDIS_ANALYSIS_EXPIRE_TIME = 2 * 60;

    /**
     * 注册答题送书的默认答题结果
     */
    String USER_REGISTER_SEND_BOOK_DEFAULT_ANSWER = "USER:REGISTER:ANSWER:DEFAULT:";

    /**
     * 闪屏广告推送时间
     */
    String STARTUP_AD_PUSH_TIME = "STARTUP:AD:PUSH_TIME";
    String STARTUP_AD_PUSHING_TIME = "STARTUP:AD:PUSHING_TIME:";

    /**
     * 图书包
     */
    String REDIS_BOOKPACKAGE_DETAIL = "BOOKPACKAGE:DETAIL:";

    /**
     * 课程
     */
    String REDIS_COURSE_DETAIL = "COURSE:DETAIL:";

    /**
     * 课时
     */
    String REDIS_CHAPTER_DETAIL = "CHAPTER:DETAIL:";

    /**
     * 咿啦家园拉取动画书信息KEY
     */
    String key_prefix = "HOME_PULL_BOOK:";

    /**
     * 听书首页模块data缓存redis_key
     */
    /**
     * String LISTEN_APP_HOME_KEY = "LISTEN:APP:HOME"
     */
    String LISTEN_APP_HOME_KEY = "LISTEN:APP:HOME";

    /**
     * 听单 列表样式   HORIZONTAL_NO_SUBTITLE:横排无音频副标题
     */
    String LB_LISTEN_LIST_TYPE_NO_SUBTITLE = "HORIZONTAL_NO_SUBTITLE";


    /**
     * 睡前听页面标识
     */
    String LISTEN_SLEEP = "LISTEN_SLEEP";

    String LISTEN_CODE = "\\{listenCode}";

    String PART_TYPE = "\\{partType}";

    String LIST_TYPE = "\\{listType}";

    String TITLE = "\\{title}";

    /**
     * 听书听单模块横板展示路由code
     */
    String LB_LISTEN_HORIZONTAL_NO_SUBTITLE = "LB_LISTEN_HORIZONTAL_NO_SUBTITLE";


    int MAX_PAGE_SIZE = 1000;
    /**
     * 听书播放器路由Code
     */
    String LB_PLAYER = "LB_PLAYER";

    /**
     * 音频分类缓存rediskey
     */
    String LB_AUDIO_SORT_KEY = "ELLA:APP:DATA:LB:AUDIO_SORT";
    /**
     * 图书合集
     */
    String REDIS_BOOK_SERIES_DETAIL = "BOOK:SERIES:DETAIL:";

    /**
     * 热门搜索
     */
    String REDIS_APP_SEARCH_POPULARSEARCH = "APP:SEARCH:POPULARSEARCH";

    /**
     * 听书首页分类固定code
     */
    String LB_HOME_PAGE_CLASS_CODE = "WKSORT99";

    /**
     * 书籍百科分类v2.4.1
     */
    String REDIS_BOOK_CLASSIFIED = "BOOK:CLASSIFIED:";

    /**
     * 福卡活动抽奖
     */
    String REDIS_ACTIVITY_DRAW_FK = "ACTIVITY:DRAW:FK:";
    /**
     * 阅读报告 v2.4.3
     */
    String REDIS_USER_READ_PRESENTATION = "USER:READ:PRESENTATION:";
    String REDIS_USER_MASTER_CHILD = "USER:MASTER:CHILD:";
    String REDIS_USER_READ_HISTORY = "USER:READ_HISTORY:";

    /**
     * 国家编号
     */
    String COUNTRY_CODE = "USER:COUNTRY:CODE:";
    /**
     * 图书专题 v2.4.7
     */
    String REDIS_BOOK_SUBJECT_PURCHASE_NOTES = "BOOK:SUBJECT:PURCHASE:NOTES";

    /**
     * 订单相关
     */

    String REDIS_ORDER_CALLBACK_FAIL = "ORDER:CALLBACK:FAIL:";
    String REDIS_ORDER_CALLBACK_RETRY_LOCK = "ORDER:CALLBACK:RETRY:LOCK:";
    String REDIS_IOS_CERTIFICATE_RETRY_LOCK = "ORDER:IOS:CERTIFICATE:RETRY:LOCK:";
    String REDIS_ORDER_IOS_CERTIFICATE_FAIL = "ORDER:IOS:CERTIFICATE:FAIL:";
    String REDIS_ORDER_IOS_CERTIFICATE_ERROR = "ORDER:IOS:CERTIFICATE:ERROR:";
    String REDIS_ORDER_IOS_VIP_FAIL = "ORDER:IOS:VIP:AUTO:FAIL:";
    String REDIS_VIP_AUTO_RETRY_LOCK = "ORDER:IOS:VIP:AUTO:RETRY:LOCK:";
    String REDIS_VIP_USER_BOUGHT_LOCK = "ORDER:ANDROID:VIP:AUTO:BOUGHT:LOCK:";
    String REDIS_ORDER_ANDROID_PAYPAL_CANCEL_FAIL = "ORDER:ANDROID:PAYPAL:CANCEL:FAIL:";
    String REDIS_ORDER_IOS_TRIAL_ORDER = "ORDER:IOS:VIP:TRIAL:ORDER:";
    String REDIS_ORDER_IOS_TRIAL_NOT_ENJOYED = "ORDER:IOS:VIP:TRIAL:NOT_ENJOYED:";
    String REDIS_ORDER_EARNING_INTERNATIONAL = "ORDER:EARNING:INTERNATIONAL:DETAIL";
    String REDIS_ORDER_EARNING_INTERNATIONAL_LOCK = "ORDER:EARNING:INTERNATIONAL:LOCK";
    String REDIS_ORDER_CASH_BUY_BOOK_SITE_CODE = "ORDER:CASH_BUY_BOOK:SITE_CODE:";


    /**
     * 步步高相关
     */
    String BOOK_DETAIL_FOR_BBK_SDK = "BOOK:DETAIL:FOR:BBK_SDK:";
    String BBK_BOOK_SYNC_RETRY = "BBK:BOOK:SYNC:RETRY:";
    String BBK_BOOK_SYNC_RETRY_LOCK = "BBK:BOOK:SYNC:RETRY:LOCK:";
    String BBK_BOOK_SYNC_PACKAGE_RETRY = "BBK:BOOK:SYNC:PACKAGE:RETRY:";
    String BBK_BOOK_SYNC_PACKAGE_RETRY_LOCK = "BBK:BOOK:SYNC:PACKAGE:RETRY:LOCK";
    String BBK_BOOK_SYNC_BATCH_LOCK = "BBK:BOOK:SYNC:BATCH:LOCK";
    String BBK_BOOK_SYNC_PACKAGE_BATCH_LOCK = "BBK:BOOK:SYNC:PACKAGE:BATCH:LOCK";
    String BBK_ORDER_CREATE_RETRY = "BBK:ORDER:CREATE:RETRY:";
    String BBK_ORDER_CREATE_RETRY_LOCK = "BBK:ORDER:CREATE:RETRY:LOCK:";
    String BBK_ORDER_CREATE_BATCH_LOCK = "BBK:ORDER:CREATE:BATCH:LOCK";

    String BBK_ORDER_MODIFY_RETRY = "BBK:ORDER:MODIFY:RETRY:";
    String BBK_ORDER_MODIFY_RETRY_LOCK = "BBK:ORDER:MODIFY:RETRY:LOCK:";
    String BBK_ORDER_MODIFY_BATCH_LOCK = "BBK:ORDER:MODIFY:BATCH:LOCK";
    long BBK_ORDER_LOCK_EXPIRE_TIME = 30;


    /**
     * boe相关
     */
    /**
     * 获取boe用户书籍的useState
     */
    String BOE_STUDY_BOOK_STATE = "BOE:STUDY:BOOK:STATE:";
    long REDIS_BOE_EXPIRE_TIME = 3 * 60;

    String MQ_SERVICE_MESSAGE = "MQ:SERVICEMESSAGE:";

    /**
     * 当前站点无版权图书目录
     */
    String SITE_COPYRIGHT_RESTRICTION_BOOK_CODE = "BOOK:SITE:COPYRIGHT_RESTRICTION:";

    /**
     * 华为
     */
    String REDIS_HUAWEI_BOOK_AUTH = "HUAWEI:BOOK:AUTH:${uid}:${courseId}";
    String REDIS_HUAWEI_BOOK_RESOURCE = "HUAWEI:BOOK:RESOURCE:";
    String REDIS_HUAWEI_ORDER = "HUAWEI:ORDER:";
    String REDIS_HUAWEI_GOODS = "HUAWEI:GOODS:";
    String REDIS_HUAWEI_LOCK_ORDER = "HUAWEI:LOCK:ORDER:";
    String REDIS_HUAWEI_LOCK_BOOK_STUDY = "HUAWEI:LOCK:BOOK:STUDY:${uid}:${book}";

    String REDIS_HUAWEI_BOOK_STUDY_FAIL = "HUAWEI:FAIL:BOOK_STUDY:";
    String REDIS_HUAWEI_ORDER_FAIL = "HUAWEI:FAIL:ORDER:";
    String REDIS_HUAWEI_CUSTOMER_FAIL = "HUAWEI:FAIL:CUSTOMER:";

    /**
     * 首页展示的partCode列表
     */
    String REDIS_H5_BOOK_PART_CODE_HOME = "BOOK:H5:PART_CODE:HOME";
    /**
     * 图书列表中展示的partCode
     */
    String REDIS_H5_BOOK_PART_CODE_BOOK_LIST = "BOOK:H5:PART_CODE:BOOK_LIST";
    String REDIS_H5_BOOK_PART_BOOK = "BOOK:H5:PART_CODE:BOOK";

    /**************************** v2.7.9 注册送书/创建孩子 *****************************/
    String REDIS_USER_REGISTER_BOOKCODES = "USER:REGISTER:DEFAULT:BOOKCODES:";
    String REDIS_USER_REGISTER_CHILDREN = "USER:REGISTER:DEFAULT:CHILDREN:";

    /**
     * 2.8.3 海外用户连续付费会员订单和会员时长
     */
    String SYN_ORDER_VIP_END_TIME = "ORDER:ORDER_VIP_END_TIME";
}