package com.commons.util;

import com.analysis.entity.ellabook.dto.OverviewDashboardDTO;
import org.apache.commons.lang3.Conversion;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.*;

public class CombineBeansUtil {
    private static Logger logger = LoggerFactory.getLogger(Conversion.class);

    /**
     * @param sourceBean 被提取的对象bean
     * @param targetBean 用于合并的对象bean
     * @return targetBean 合并后的对象
     * @Description: 该方法是用于相同对象不同属性值的合并，如果两个相同对象中同一属性都有值，
     * 那么sourceBean中的值会覆盖targetBean重点的值
     * @return: Object
     */
    @SuppressWarnings("unused")
    public static <T> T combineBeans(T sourceBean, T targetBean) {
        Class sourceBeanClass = sourceBean.getClass();
        Class targetBeanClass = targetBean.getClass();

        Field[] sourceFields = sourceBeanClass.getDeclaredFields();
        Field[] targetFields = sourceBeanClass.getDeclaredFields();
        for (int i = 0; i < sourceFields.length; i++) {
            Field sourceField = sourceFields[i];
            Field targetField = targetFields[i];
            sourceField.setAccessible(true);
            targetField.setAccessible(true);
            try {
                if (!(sourceField.get(sourceBean) == null)) {
                    targetField.set(targetBean, sourceField.get(sourceBean));
                }
            } catch (IllegalArgumentException | IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return targetBean;
    }

    /**
     * @param sourceBean 被提取的对象bean
     * @param targetBean 被复制的对象bean
     * @return targetBean 复制后的对象
     * @Description: 将sourceBean中类型和名称相同的属性值赋值给对应的targetBean的属性，并返回targetBean
     * @return: Object
     */
    public static <T1, T2> T2 copyBeans(T1 sourceBean, T2 targetBean) {
        List<Map<String, Object>> modelList = getFiledInfo(sourceBean);
        List<Map<String, Object>> entityList = getFiledInfo(targetBean);
        for (Map e : entityList) {
            for (Map m : modelList) {
                /**
                 * 判断类型和属性名是否都相同
                 */
                if (e.get("type").toString().equals(m.get("type").toString()) && e.get("name")
                        .toString()
                        .equals(m.get("name").toString())) {
                    try {
                        Field f = targetBean.getClass().getDeclaredField(e.get("name").toString());
                        f.setAccessible(true);
                        f.set(targetBean, m.get("value"));
                    } catch (Exception ex) {//查看其父类属性
                        try {
                            Field f = targetBean.getClass().getSuperclass().getDeclaredField(e.get("name").toString());
                            f.setAccessible(true);
                            f.set(targetBean, m.get("value"));
                        } catch (Exception e1) {
                            logger.error(ex.getMessage(), "conversion类型转换错误 " + ex);
                        }
                    }
                }
            }
        }
        return targetBean;
    }

    /**
     * 获取属性类型(type)，属性名(name)，属性值(value)的map组成的list
     */
    private static List<Map<String, Object>> getFiledInfo(Object o) {
        List<Map<String, Object>> list = new ArrayList<>();
        List<Field> fields = new ArrayList<>();
        fields.addAll(Arrays.asList(o.getClass().getDeclaredFields()));

        /**
         * 如果存在父类，获取父类的属性值，类型，名称并添加到一起
         */
        Class sc = o.getClass().getSuperclass();
        if (sc != null) {
            fields.addAll(Arrays.asList(sc.getDeclaredFields()));
        }
        for (Field field : fields) {
            Map<String, Object> infoMap = new HashMap<>();
            infoMap.put("type", field.getType().toString());
            infoMap.put("name", field.getName());
            infoMap.put("value", getFieldValueByName(field.getName(), o));
            list.add(infoMap);
        }
        return list;
    }

    /**
     * 根据属性名获取属性值
     */
    private static Object getFieldValueByName(String fieldName, Object o) {
        try {
            String firstLetter = fieldName.substring(0, 1).toUpperCase();
            String getter = "get" + firstLetter + fieldName.substring(1);
            Method method = o.getClass().getMethod(getter, new Class[]{});
            Object value = method.invoke(o, new Object[]{});
            return value;
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            return null;
        }
    }

    /**
     * 获取属性名数组
     */
    private static String[] getFiledName(Object o) {
        Field[] fields = o.getClass().getDeclaredFields();
        String[] fieldNames = new String[fields.length];
        for (int i = 0; i < fields.length; i++) {
            fieldNames[i] = fields[i].getName();
        }
        return fieldNames;
    }

    @Test
    public void test() {
        OverviewDashboardDTO sourceModel = new OverviewDashboardDTO(); // 第一个对象
        OverviewDashboardDTO targetModel = new OverviewDashboardDTO(); // 第二个model对象

        sourceModel.setRegisterUserNum(20);
        sourceModel.setActiveUserNum(21);

        targetModel.setPayAmount(new BigDecimal("55"));
        targetModel.setPayUserNum(56);

        CombineBeansUtil test = new CombineBeansUtil();
        OverviewDashboardDTO OverviewDashboardDTO = test.combineBeans(sourceModel, targetModel);
    }
}
