package com.bbk.sign.constant;

/**
 * 通用常量
 */
public class Constants {
    /**
     * 签名算法HmacSha256
     */
    public static final String HMAC_SHA256 = "HmacSHA256";
    /**
     * 编码UTF-8
     */
    public static final String ENCODING = "UTF-8";
    /**
     * 换行符
     */
    public static final String LF = "\n";
    /**
     * 串联符
     */
    public static final String SPE1 = ",";
    /**
     * 示意符
     */
    public static final String SPE2 = ":";
    /**
     * 连接符
     */
    public static final String SPE3 = "&";
    /**
     * 赋值符
     */
    public static final String SPE4 = "=";
    /**
     * 问号符
     */
    public static final String SPE5 = "?";
    /**
     * 参与签名的系统Header前缀,只有指定前缀的Header才会参与到签名中
     */
    public static final String CA_HEADER_TO_SIGN_PREFIX_SYSTEM = "s-";
    /**
     * 参与签名的用户自定义Header前缀,只有约定前缀的Header才会参与到签名中
     */
    public static final String CA_HEADER_TO_SIGN_PREFIX_USER = "u-";
    /**
     * 头信息版本
     */
    public static final String CA_HEADER_VERSION = "1";
    /**
     * 开启debug模式
     */
    public static final String CA_HEADER_MODEL_DEBUG = "debug";
    /**
     * 分支标识 release
     */
    public static final String CA_HEADER_STAGE_RELEASE = "release";
    /**
     * 分支标识 test
     */
    public static final String CA_HEADER_STAGE_TEST = "test";
    /**
     * json提交
     */
    public static final String APPLICATION_JSON = "application/json";

}
