package com.analysis.util;

import com.ellabook.util.BigDecimalUtil;
import org.junit.Test;

import java.math.BigDecimal;

public class RateUtil {
    /**
     * 百分比计算
     *
     * @param v1 被除数
     * @param v2 除数
     * @return
     */
    public static String rateConvert(Integer v1, Integer v2) {
        v1 = (v1 == null) ? 0 : v1;
        v2 = (v2 == null) ? 0 : v2;

        if (v2 != 0) {
            return String.valueOf(BigDecimalUtil.mul(BigDecimalUtil.div(v1, v2, 4), 100));
        } else {
            return "0.00";
        }
    }

    /**
     * 数字 增长率计算
     *
     * @param v1 本期增长数量
     * @param v2 上期增长数量
     * @return
     */
    public static String growthRateConvert(Integer v1, Integer v2) {
        v1 = (v1 == null) ? 0 : v1;
        v2 = (v2 == null) ? 0 : v2;
        if (v2 != 0) {
            return String.valueOf(BigDecimalUtil.mul(BigDecimalUtil.div((v1 - v2), v2, 4), 100, 4));
        } else {
            return "100.00";
        }
    }

    /**
     * 金额 增长率计算
     *
     * @param v1 本期增长数量
     * @param v2 上期增长数量
     * @return
     */
    public static String growthAmountRateConvert(BigDecimal v1, BigDecimal v2) {
        v1 = (v1 == null) ? new BigDecimal("0") : v1;
        v2 = (v2 == null) ? new BigDecimal("0") : v2;
        if (v2.compareTo(new BigDecimal("0")) != 0) {
            BigDecimal difference = BigDecimalUtil.sub(v1, v2, 2);  // 两个参数的差
            BigDecimal quotient = BigDecimalUtil.div(difference, v2, 4);// 两个参数的商
            BigDecimal rate = BigDecimalUtil.mul(quotient, new BigDecimal(100), 2); // 百分比
            return String.valueOf(rate);
        } else {
            return "100.00";
        }
    }

    /**
     * 金额 增长率计算
     *
     * @param v1 本期增长数量
     * @param v2 上期增长数量
     * @return
     */
    public static double amountSubConvert(BigDecimal v1, BigDecimal v2) {
        v1 = (v1 == null) ? new BigDecimal("0") : v1;
        v2 = (v2 == null) ? new BigDecimal("0") : v2;
        BigDecimal difference = BigDecimalUtil.sub(v1, v2, 2);  // 两个参数的差
        return difference.doubleValue();
    }

    @Test
    public void test() {
        BigDecimal v1 = new BigDecimal("1");
        BigDecimal v2 = new BigDecimal("2");
//        System.out.println(growthAmountRateConvert(v1, v2));
    }
}
