package com.analysis.util;

import org.apache.commons.lang.StringUtils;
import org.junit.Test;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;

import static com.analysis.util.AnalysisStatusConstantUtil.*;

public class DateUtil {
    public static String DATE_DAY_PATTERN = "yyyy-MM-dd";
    public static String TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static String MILLIS_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss:SSS";
    static SimpleDateFormat dayFormat = new SimpleDateFormat(DATE_DAY_PATTERN);
    static SimpleDateFormat timeFormat = new SimpleDateFormat(TIME_PATTERN);
    static SimpleDateFormat millisFormat = new SimpleDateFormat(MILLIS_TIME_PATTERN);

    /**
     * 获取某天已经过N小时
     *
     * @return
     */
    public static long getCurrentHoursHavePassed(String date) {
        long hour;
        if (getCurrentDayToStr().equals(date)) { //当天已经N小时
            LocalDateTime midnight = LocalDateTime.now().plusDays(0).withHour(0).withMinute(0).withSecond(0).withNano(0);
            hour = ChronoUnit.HOURS.between(midnight, LocalDateTime.now());
        } else {
            hour = DateUtil.getBetweenTime(getCurrentDayToStr(), date) > 0 ? 0 : 24;
        }
        return hour;
    }

    public static String getDateFormatToStr(Date date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date.getTime());
    }


    public static String getDateFormat(String date, String type) {
//        SimpleDateFormat sdf = new SimpleDateFormat(format);2017 0216 2045 14
        if (StringUtils.isNotBlank(date)) {
            if (type.equals("date") && date.length() >= 8) {
                date = dateStrSub(date, "date");
            } else if (type.equals("time") && date.length() >= 14) {
                date = dateStrSub(date, "time");
            } else if (type.equals("datetime") && date.length() >= 14) {
                date = dateStrSub(date, "date") + " " + dateStrSub(date, "time");
            }
        }
        return date;
    }

    public static String dateStrSub(String date, String type) {
        String subDate = "";
        if (type.equals("date") && date.length() >= 8) {
            subDate = date.substring(0, 4) + "-" + date.substring(4, 6) + "-" + date.substring(6, 8);
        } else if (type.equals("date") && date.length() == 8) {
            subDate = date.substring(0, 4) + "-" + date.substring(4, 6) + "-" + date.substring(6);
        } else if (type.equals("time") && date.length() > 14) {
            subDate = date.substring(8, 10) + ":" + date.substring(10, 12) + ":" + date.substring(12, 14);
        } else if (type.equals("time") && date.length() >= 14) {
            subDate = date.substring(8, 10) + ":" + date.substring(10, 12) + ":" + date.substring(12);
        }
        return subDate;
    }

    @Test
    public void test1() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        try {
            date = sdf.parse("20190115184743");
            System.out.println(sdf.format(date));
        } catch (ParseException e) {
            e.printStackTrace();
        }

    }

    /**
     * 获取当前日期
     */
    public static String getNextDayToStr() {
        Calendar calendar = Calendar.getInstance();
        int day = calendar.get(Calendar.DATE);
        calendar.set(Calendar.DATE, day + 1);
        return getDateFormatToStr(calendar.getTime(), DATE_DAY_PATTERN);
    }

    /**
     * 获取当前日期
     */
    public static String getCurrentDayToStr() {
        Calendar calendar = Calendar.getInstance();
        return getDateFormatToStr(calendar.getTime(), DATE_DAY_PATTERN);
    }

    /**
     * 获取上一天日期
     */
    public static String getLastDayToStr() {
        Calendar calendar = Calendar.getInstance();
        int day = calendar.get(Calendar.DATE);
        calendar.set(Calendar.DATE, day - 1);
        return getDateFormatToStr(calendar.getTime(), DATE_DAY_PATTERN);
    }

    /**
     * 获取上周第一天日期
     */
    public static String getLastWeekFirstDayToStr() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.DAY_OF_WEEK, Calendar.MONDAY);
        calendar.setTime(calendar.getTime());
        calendar.add(Calendar.DAY_OF_WEEK, -7);
        return getDateFormatToStr(calendar.getTime(), DATE_DAY_PATTERN);
    }

    /**
     * 获取上周最后一天日期
     */
    public static String getLastWeekLastDayToStr() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.DAY_OF_WEEK, Calendar.MONDAY);
        calendar.setTime(calendar.getTime());
        calendar.add(Calendar.DAY_OF_WEEK, -1);
        return getDateFormatToStr(calendar.getTime(), DATE_DAY_PATTERN);
    }

    /**
     * 获取本周第一天日期
     */
    public static String getCurrentWeekFirstDayToStr() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.DAY_OF_WEEK, Calendar.MONDAY);
//        calendar.set(Calendar.HOUR_OF_DAY, 0);
//        calendar.set(Calendar.MINUTE, 0);
//        calendar.set(Calendar.SECOND, 0);
        return getDateFormatToStr(calendar.getTime(), DATE_DAY_PATTERN);
    }

    /**
     * 获取下周第一天日期
     */
    public static String getNextWeekFirstDayToStr() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.DAY_OF_WEEK, Calendar.MONDAY);
        calendar.setTime(calendar.getTime());
        calendar.add(Calendar.DAY_OF_WEEK, 7);
        return getDateFormatToStr(calendar.getTime(), DATE_DAY_PATTERN);
    }

    /**
     * 获取上月第一天日期
     */
    public static String getLastMonthFirstDayToStr() {
        Calendar calendar = Calendar.getInstance();//获取当前日期
        calendar.add(Calendar.MONTH, -1);
        calendar.set(Calendar.DAY_OF_MONTH, 1);//设置为1号,当前日期既为本月第一天
        return getDateFormatToStr(calendar.getTime(), DATE_DAY_PATTERN);
    }

    /**
     * 获取上月最后一天日期
     */
    public static String getLastMonthLastDayToStr() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.DAY_OF_MONTH, 0);
        return getDateFormatToStr(calendar.getTime(), DATE_DAY_PATTERN);
    }

    /**
     * 获取本月第一天日期
     */
    public static String getCurrentMonthFirstDayToStr() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.DAY_OF_MONTH, 1);
        return getDateFormatToStr(calendar.getTime(), DATE_DAY_PATTERN);
    }

    /**
     * 获取本月最后一天日期
     */
    public static String getCurrentMonthLastDayToStr() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.MONTH, 1);
        calendar.set(Calendar.DAY_OF_MONTH, 0);
        return getDateFormatToStr(calendar.getTime(), DATE_DAY_PATTERN);
    }

    /**
     * 获取下月第一天日期
     */
    public static String getNextMonthFirstDayToStr() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.MONTH, 1);
        calendar.set(Calendar.DAY_OF_MONTH, 1);
        return getDateFormatToStr(calendar.getTime(), DATE_DAY_PATTERN);
    }

    /**
     * 获取下月最后一天日期
     */
    public static String getNextMonthLastDayToStr() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.MONTH, 2);
        calendar.set(Calendar.DAY_OF_MONTH, 0);
        return getDateFormatToStr(calendar.getTime(), DATE_DAY_PATTERN);
    }

    /**
     * 获取当前日期
     */
    public static Date getCurrentDay() {
        Calendar calendar = Calendar.getInstance();
        return calendar.getTime();
    }

    /**
     * 获取当前日期
     */
    public static Date getNextDay() {
        Calendar calendar = Calendar.getInstance();
        int day = calendar.get(Calendar.DATE);
        calendar.set(Calendar.DATE, day + 1);
        return calendar.getTime();
    }


    /**
     * 获取上一天日期
     */
    public static Date getLastDay() {
        Calendar calendar = Calendar.getInstance();
        int day = calendar.get(Calendar.DATE);
        calendar.set(Calendar.DATE, day - 1);
        return calendar.getTime();
    }

    /**
     * 获取上周第一天日期
     */
    public static Date getLastWeekFirstDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.DAY_OF_WEEK, Calendar.MONDAY);
        calendar.setTime(calendar.getTime());
        calendar.add(Calendar.DAY_OF_WEEK, -7);
        return calendar.getTime();
    }

    /**
     * 获取上周第一天日期
     */
    public static Date getLastWeekLastDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.DAY_OF_WEEK, Calendar.SUNDAY);
        calendar.setTime(calendar.getTime());
        calendar.add(Calendar.DAY_OF_WEEK, -7);
        return calendar.getTime();
    }

    /**
     * 获取本周第一天日期
     */
    public static Date getCurrentWeekFirstDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.DAY_OF_WEEK, Calendar.MONDAY);
//        calendar.set(Calendar.HOUR_OF_DAY, 0);
//        calendar.set(Calendar.MINUTE, 0);
//        calendar.set(Calendar.SECOND, 0);
        return calendar.getTime();
    }

    /**
     * 获取下周第一天日期
     */
    public static Date getNextWeekFirstDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.DAY_OF_WEEK, Calendar.MONDAY);
        calendar.setTime(calendar.getTime());
        calendar.add(Calendar.DAY_OF_WEEK, 7);
        return calendar.getTime();
    }

    /**
     * 获取上月第一天日期
     */
    public static Date getLastMonthFirstDay() {
        Calendar calendar = Calendar.getInstance();//获取当前日期
        calendar.add(Calendar.MONTH, -1);
        calendar.set(Calendar.DAY_OF_MONTH, 1);//设置为1号,当前日期既为本月第一天
        return calendar.getTime();
    }

    /**
     * 获取上月最后一天日期
     */
    public static Date getLastMonthLastDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.DAY_OF_MONTH, 0);
        return calendar.getTime();
    }

    /**
     * 获取本月第一天日期
     */
    public static Date getCurrentMonthFirstDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.DAY_OF_MONTH, 1);
        return calendar.getTime();
    }

    /**
     * 获取本月最后一天日期
     */
    public static Date getCurrentMonthLastDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.MONTH, 1);
        calendar.set(Calendar.DAY_OF_MONTH, 0);
        return calendar.getTime();
    }

    /**
     * 获取下月第一天日期
     */
    public static Date getNextMonthFirstDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.MONTH, 1);
        calendar.set(Calendar.DAY_OF_MONTH, 1);
        return calendar.getTime();
    }

    /**
     * 获取下月最后一天日期
     */
    public static Date getNextMonthLastDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.MONTH, 2);
        calendar.set(Calendar.DAY_OF_MONTH, 0);
        return calendar.getTime();
    }

    /**
     * 获取当天/当周/当月剩余时间
     */
    public static long getExpireTime(String dateType) {
        long expireTime = 0;
        if (dateType.equals(DAY)) {
            expireTime = getTimeByDate(getNextDay()) - new Date().getTime();
        } else if (dateType.equals(WEEK)) {
            expireTime = getTimeByDate(getNextWeekFirstDay()) - new Date().getTime();
        } else if (dateType.equals(MONTH)) {
            expireTime = getTimeByDate(getNextMonthFirstDay()) - new Date().getTime();
        }
        return expireTime / 1000;
    }

    /**
     * 获取日期的毫秒数
     *
     * @param date
     * @return
     */
    public static long getTimeByDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
//        calendar.add(calendar.DAY_OF_MONTH, 1);
        calendar.set(calendar.HOUR_OF_DAY, 0);
        calendar.set(calendar.MINUTE, 0);
        calendar.set(calendar.SECOND, 0);
        calendar.set(calendar.MILLISECOND, 0);
        return calendar.getTime().getTime();
    }

    public static String getFistDayOfMonth(String date) {
        SimpleDateFormat format = new SimpleDateFormat(DATE_DAY_PATTERN);
        String firstDay = "";
        try {
            Date newDate = format.parse(date);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(newDate);
            calendar.set(Calendar.DAY_OF_MONTH, 1);
            firstDay = getDateFormatToStr(calendar.getTime(), DATE_DAY_PATTERN);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return firstDay;
    }

    public static String getLastDayOfMonth(String date) {
        SimpleDateFormat format = new SimpleDateFormat(DATE_DAY_PATTERN);
        String firstDay = "";
        try {
            Date newDate = format.parse(date);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(newDate);
            calendar.add(Calendar.MONTH, 1);//加一个月
            calendar.set(Calendar.DATE, 1);//设置为该月第一天
            calendar.add(Calendar.DATE, -1);//再减一天即为上个月最后一天
            firstDay = getDateFormatToStr(calendar.getTime(), DATE_DAY_PATTERN);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return firstDay;
    }

    public static String getDayOfWeek(String date, String type) {
        SimpleDateFormat format = new SimpleDateFormat(DATE_DAY_PATTERN);
        String firstDay = "";
        try {
            Date newDate = format.parse(date);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(newDate);
            int d = 0;
            if (calendar.get(Calendar.DAY_OF_WEEK) == 1) {  //
                d = -7;
            } else {
                d = 2 - calendar.get(Calendar.DAY_OF_WEEK);
            }
            calendar.add(Calendar.DAY_OF_WEEK, d);
            if (type.equals(LAST_DAY)) {
                calendar.add(Calendar.DAY_OF_WEEK, 6);
            }
            //所在周开始日期
            firstDay = getDateFormatToStr(calendar.getTime(), DATE_DAY_PATTERN);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return firstDay;
    }

    // 上周一
    public static Date geLastWeekMonday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(getCurrentWeekMonday(date));
        cal.add(Calendar.DATE, -7);
        return cal.getTime();
    }

    // 本周一
    public static Date getCurrentWeekMonday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        // 获得当前日期是一个星期的第几天
        int dayWeek = cal.get(Calendar.DAY_OF_WEEK);
        if (1 == dayWeek) {
            cal.add(Calendar.DAY_OF_MONTH, -1);
        }
        // 设置一个星期的第一天，按中国的习惯一个星期的第一天是星期一
        cal.setFirstDayOfWeek(Calendar.MONDAY);
        // 获得当前日期是一个星期的第几天
        int day = cal.get(Calendar.DAY_OF_WEEK);
        // 根据日历的规则，给当前日期减去星期几与一个星期第一天的差值
        cal.add(Calendar.DATE, cal.getFirstDayOfWeek() - day);
        return cal.getTime();
    }

    // 上周日
    public static Date getBeforeWeekSunday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(getCurrentWeekMonday(date));
        cal.add(Calendar.DATE, -1);
        return cal.getTime();
    }

    // 本月一号
    public static Date getMonthFirstDay() {
        // SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar1 = Calendar.getInstance();
        calendar1.set(Calendar.DAY_OF_MONTH, 1);
        // System.out.println("本月第一天: "+sdf.format(calendar1.getTime()));
        return calendar1.getTime();
    }

    /**
     * 本月最后一天
     *
     * @return
     */
    public static Date getMonthLastDay() {
        Calendar ca = Calendar.getInstance();
        ca.set(Calendar.DAY_OF_MONTH, ca.getActualMaximum(Calendar.DAY_OF_MONTH));
        return ca.getTime();
    }

    // 上月一号
    public static Date beforeMonthFirstDay() {
        // SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar5 = Calendar.getInstance();
        int maxCurrentMonthDay = calendar5.getActualMaximum(Calendar.DAY_OF_MONTH);
        calendar5.add(Calendar.DAY_OF_MONTH, -maxCurrentMonthDay);
        calendar5.set(Calendar.DAY_OF_MONTH, 1);
        // System.out.println("上月第一天: "+sdf.format(calendar5.getTime()));
        return calendar5.getTime();
    }

    // 上月最后一天
    public static Date beforeMonthLastDay() {
        // SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar6 = Calendar.getInstance();
        int maxCurrentMonthDay = calendar6.getActualMaximum(Calendar.DAY_OF_MONTH);
        calendar6.add(Calendar.DAY_OF_MONTH, -maxCurrentMonthDay);
        // 第一个maxCurrentMonthDay获取的是当月的天数，第二个maxCurrentMonthDay获取的是上个月的天数
        maxCurrentMonthDay = calendar6.getActualMaximum(Calendar.DAY_OF_MONTH);
        calendar6.set(Calendar.DAY_OF_MONTH, maxCurrentMonthDay);
        // System.out.println("上月第一天: "+sdf.format(calendar6.getTime()));
        return calendar6.getTime();
    }

    public static Date getBeforeDay(Date today) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(today);
        calendar.add(Calendar.DAY_OF_YEAR, -1);
        return calendar.getTime();
    }

    /**
     * 获取本周日
     *
     * @return
     */
    public static Date getSundayOfThisWeek() {
        Calendar c = Calendar.getInstance();
        int day_of_week = c.get(Calendar.DAY_OF_WEEK) - 1;
        if (day_of_week == 0)
            day_of_week = 7;
        c.add(Calendar.DATE, -day_of_week + 7);
        return c.getTime();
    }

    /**
     * 两个日期之间相差天数
     *
     * @param startDate
     * @param endDate
     * @return
     */
    public static Integer getDayBetweenNum(String startDate, String endDate) {
        SimpleDateFormat format = new SimpleDateFormat(DATE_DAY_PATTERN);
        Integer dayNum = 0;
        try {
            Date start = format.parse(startDate);
            Date end = format.parse(endDate);
            dayNum = (int) ((end.getTime() - start.getTime()) / (1000 * 60 * 60 * 24));
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return dayNum;
    }

    /**
     * 两个日期之间相差天数
     *
     * @param startDate
     * @param endDate
     * @return
     */
    public static Integer getDayBetweenNum(String startDate, String endDate, String currentDate) {
        long time = DateUtil.getBetweenTime(currentDate, endDate);
        if (time >= 0) { //包含当天，结束为当天
            endDate = currentDate;
        }
        Integer dayNum = getDayBetweenNum(startDate, endDate);
        return dayNum;
    }

    /**
     * 两个日期之间相差周数
     *
     * @param startDate
     * @param endDate
     * @return
     */
    public static Integer getWeekBetweenNum(String startDate, String endDate) {
        SimpleDateFormat format = new SimpleDateFormat(DATE_DAY_PATTERN);
        Integer weekNum = 0;
        try {
            long start = format.parse(startDate).getTime();
            long end = format.parse(endDate).getTime();
            weekNum = (int) ((end - start) / (1000 * 3600 * 24 * 7));
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return weekNum;
    }

    /**
     * 两个日期之间相差月数
     *
     * @param startDate
     * @param endDate
     * @return
     */
    public static Integer getMonthBetweenNum(String startDate, String endDate) {
        SimpleDateFormat format = new SimpleDateFormat(DATE_DAY_PATTERN);
        Integer monthNum = 0;
        try {
            Calendar startCalendar = Calendar.getInstance();
            Calendar endCalendar = Calendar.getInstance();
            startCalendar.setTime(format.parse(startDate));
            endCalendar.setTime(format.parse(endDate));
            monthNum = getYearBetweenNum(startDate, endDate) * 12 + endCalendar.get(Calendar.MONTH) - startCalendar.get(Calendar.MONTH);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return monthNum;
    }

    /**
     * 两个日期之间相差年数
     *
     * @param startDate
     * @param endDate
     * @return
     * @throws ParseException
     */
    public static int getYearBetweenNum(String startDate, String endDate) {
        SimpleDateFormat format = new SimpleDateFormat(DATE_DAY_PATTERN);
        int yearNum = 0;
        try {
            Calendar startCalendar = Calendar.getInstance();
            Calendar endCalendar = Calendar.getInstance();
            startCalendar.setTime(format.parse(startDate));
            endCalendar.setTime(format.parse(endDate));
            yearNum = (endCalendar.get(Calendar.YEAR) - startCalendar.get(Calendar.YEAR));
        } catch (ParseException e) {
            e.printStackTrace();
        }

        return yearNum;
    }

    /**
     * 获取下一个日期
     *
     * @param startTimeStr
     * @param feild
     * @param amount
     * @return
     */
    public static String getNextDateToStr(String startTimeStr, Integer feild, Integer amount) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date endTime = null;
        try {
            Date startTime = format.parse(startTimeStr);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(startTime);
            calendar.add(feild, amount);
            endTime = calendar.getTime();
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return format.format(endTime);
    }


    /**
     * 数据清除开始时间当前日期的天/周/月数
     *
     * @param date
     * @param dateType
     * @return
     */
    public static Integer dayNumConvert(String date, String dateType) {
        Integer num = 0;
        if (dateType.equals(DAY)) {
            num = DateUtil.getDayBetweenNum(date, DateUtil.getCurrentDayToStr());
        } else if (dateType.equals(WEEK)) {
            num = DateUtil.getWeekBetweenNum(DateUtil.getDayOfWeek(date, FIRST_DAY), DateUtil.getCurrentDayToStr());
        } else if (dateType.equals(MONTH)) {
            num = DateUtil.getMonthBetweenNum(date, DateUtil.getCurrentDayToStr());
        }
        return num;
    }

    /**
     * 数据清除 天、周、月开始、结束时间处
     *
     * @param date
     * @param dateType
     * @return
     */
    public static String cleanTimeConvert(String date, String dateType, String type) {
        String cleanTime = "";
        if (dateType.equals(DAY)) {
            cleanTime = date;
        } else if (dateType.equals(WEEK)) {
            cleanTime = DateUtil.getDayOfWeek(date, type);
        } else if (dateType.equals(MONTH)) {
            if (type.equals(FIRST_DAY)) {
                cleanTime = DateUtil.getFistDayOfMonth(date);
            } else if (type.equals(LAST_DAY)) {
                cleanTime = DateUtil.getLastDayOfMonth(date);
            }
        }
        return cleanTime;
    }

    /**
     * 获取两个日期的时间差
     *
     * @param beginTime
     * @param endTime
     * @return
     */
    public static long getBetweenTime(String beginTime, String endTime) {
        long time = getTimeByDate(getStrToDate(endTime)) - getTimeByDate(getStrToDate(beginTime));
        return time;
    }

    /**
     * 字符串转日期
     *
     * @param date
     * @return
     */
    public static Date getStrToDate(String date) {
        Date convertDate = new Date();
        try {
            convertDate = dayFormat.parse(date);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return convertDate;
    }
}
