package com.analysis.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;

/**
 * Created by xixiaoyi
 * on 2017/9/28
 */
public class AnalysisCoreUtil {

    /**
     * 通用core生成 ，年月日时分秒毫秒
     *
     * @param coreFirstCharacter
     * @return
     */
    public static String createCommonsCore(String coreFirstCharacter) {
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        StringBuffer str = new StringBuffer(coreFirstCharacter);
        str.append(format.format(date));
        return str.toString();
    }

    /**
     * 通用core生成 ，年月日时分秒毫秒+随机数
     *
     * @param coreFirstCharacter
     * @return
     */
    public static String createCommonsCore(String coreFirstCharacter, int numOfRandom) {
        String random = create(numOfRandom);
        coreFirstCharacter += random;
        return coreFirstCharacter;
    }

    /**
     * 生成n位随机数
     *
     * @param numOfRandom
     * @return
     */
    public static String create(int numOfRandom) {
        StringBuffer str = new StringBuffer();
        Random random = new Random();
        for (int i = 0; i < numOfRandom; i++) {
            str.append(random.nextInt(10) + "");
        }
        return str.toString();
    }
}
