package com.analysis.entity.ellabook;

import java.math.BigDecimal;

public class OverviewChannelHour extends OverviewChannelTop {

    private String analysisTime;
    private String channelCode;

    public OverviewChannelHour(String analysisDate, String analysisTime) {
        super(analysisDate);
        this.analysisTime = analysisTime;
    }


    public OverviewChannelHour(String analysisDate, String analysisTime, String channelCode, Integer activeUserNum) {
        super(analysisDate, channelCode, activeUserNum);
        this.analysisTime = analysisTime;
        this.channelCode = channelCode;
    }

    public OverviewChannelHour(String analysisDate, String analysisTime, String channelCode) {
        super(analysisDate, channelCode);
        this.analysisTime = analysisTime;
        this.channelCode = channelCode;
    }

    public OverviewChannelHour(String analysisDate, String analysisTime, String channelCode, Integer activeUserNum,
                               Integer registerUserNum, Integer payUserNum, BigDecimal payAmount) {
        super(channelCode, analysisDate, activeUserNum, registerUserNum, payUserNum, payAmount);
        this.analysisTime = analysisTime;
        this.channelCode = channelCode;
    }

    public OverviewChannelHour(String analysisDate, String analysisTime, String channelCode,
                               Integer registerUserNum, Integer payUserNum, BigDecimal payAmount) {
        super(analysisDate, channelCode, registerUserNum, payUserNum, payAmount);
        this.analysisTime = analysisTime;
        this.channelCode = channelCode;
    }

    public String getChannelCode() {
        return channelCode;
    }


    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public String getAnalysisTime() {
        return analysisTime;
    }

    public void setAnalysisTime(String analysisTime) {
        this.analysisTime = analysisTime;
    }

}