package com.ellabook.util.doc.enums;


import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;

/**
 * @author mc
 * @date 2018/7/12
 */
public enum DocTypeAlias {
    _BYTE(byte.class, "int"),
    _SHORT(short.class, "int"),
    _INT(int.class, "int"),
    _LONG(long.class, "int"),
    _FLOAT(float.class, "int"),
    _DOUBLE(double.class, "int"),
    _BOOLEAN(boolean.class, "int"),
    _CHAR(char.class, "string"),
    BYTE(Byte.class, "int"),
    SHORT(Short.class, "int"),
    INTEGER(Integer.class, "int"),
    LONG(Long.class, "int"),
    FLOAT(Float.class, "float"),
    DOUBLE(Double.class, "float"),
    BIGDECIMAL(BigDecimal.class, "float"),
    BOOLEAN(Boolean.class, "boolean"),
    CHARACTER(Character.class, "string"),
    STRING(String.class, "string"),
    DATE(Date.class, "date"),
    ;


    private Class<?> javaType;
    private String typeAlias;

    DocTypeAlias(Class<?> javaType, String typeAlias) {
        this.javaType = javaType;
        this.typeAlias = typeAlias;
    }

    public Class<?> getJavaType() {
        return javaType;
    }

    public void setJavaType(Class javaType) {
        this.javaType = javaType;
    }

    public String getTypeAlias() {
        return typeAlias;
    }

    public void setTypeAlias(String typeAlias) {
        this.typeAlias = typeAlias;
    }

    public static String getAlias(Class<?> clz) throws Exception {
        for (DocTypeAlias docTypeAlias : DocTypeAlias.values()) {
            if (clz == docTypeAlias.getJavaType()) {
                return docTypeAlias.getTypeAlias();
            }
        }
        if (Collection.class.isAssignableFrom(clz)) {
            return "array";
        }
        return "object";
    }

    public static boolean containsJavaType(Class<?> clz) {
        for (DocTypeAlias docTypeAlias : DocTypeAlias.values()) {
            if (clz == docTypeAlias.getJavaType()) {
                return true;
            }
        }
        return false;
    }
}
