package com.ellabook.util.doc.enums;

import java.text.SimpleDateFormat;
import java.util.Date;

import static com.ellabook.util.doc.enums.EllaProject.*;

public enum DocPage {
    ELLA_APP_PAGE(0, ELLABOOK_OPERATION, 0, 99, DocPage.formatDate(), "欢迎使用ShowDoc！");

    private int pageId;
    private EllaProject itemId;
    private int catId;
    private int sNumber;
    private String pageTitle;
    private String pageContent;
    private static SimpleDateFormat format;


    DocPage() {
    }

    DocPage(int pageId, EllaProject itemId, int catId, int sNumber, String pageTitle, String pageContent) {
        this.pageId = pageId;
        this.itemId = itemId;
        this.catId = catId;
        this.sNumber = sNumber;
        this.pageTitle = pageTitle;
        this.pageContent = pageContent;
    }

    public static String formatDate() {
        format = format == null ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss") : format;
        return format.format(new Date());
    }

    public int getPageId() {
        return pageId;
    }

    public void setPageId(int pageId) {
        this.pageId = pageId;
    }

    public EllaProject getItemId() {
        return itemId;
    }

    public void setItemId(EllaProject itemId) {
        this.itemId = itemId;
    }

    public int getCatId() {
        return catId;
    }

    public void setCatId(int catId) {
        this.catId = catId;
    }

    public int getsNumber() {
        return sNumber;
    }

    public void setsNumber(int sNumber) {
        this.sNumber = sNumber;
    }

    public String getPageTitle() {
        return pageTitle;
    }

    public void setPageTitle(String pageTitle) {
        this.pageTitle = pageTitle;
    }

    public String getPageContent() {
        return pageContent;
    }

    public void setPageContent(String pageContent) {
        this.pageContent = pageContent;
    }
}
