package com.ellabook.util.doc;

import java.util.LinkedHashMap;
import java.util.Map;

public class DocEntity {
    private String developer;
    private String InfDesc;
    private String InfUrl = "http://ip:port/rest/api/service";
    private String requestType = "POST";
    private String method;
    private Map<String, String> errorCodeAndMessage = new LinkedHashMap<>();

    public Map<String, String> getErrorCodeAndMessage() {
        return errorCodeAndMessage;
    }

    public DocEntity setErrorCodeAndMessage(Map<String, String> errorCodeAndMessage) {
        this.errorCodeAndMessage = errorCodeAndMessage;
        return this;
    }

    public DocEntity(String developer) {
        this.developer = developer;
    }

    public String getDeveloper() {
        return developer;
    }

    public String getInfDesc() {
        return InfDesc;
    }

    public DocEntity setInfDesc(String infDesc) {
        InfDesc = infDesc;
        return this;
    }

    public String getInfUrl() {
        return InfUrl;
    }

    public DocEntity setInfUrl(String infUrl) {
        InfUrl = infUrl;
        return this;
    }

    public String getRequestType() {
        return requestType;
    }

    public DocEntity setRequestType(String requestType) {
        this.requestType = requestType;
        return this;
    }

    public String getMethod() {
        return method;
    }

    public DocEntity setMethod(String method) {
        this.method = method;
        return this;
    }
}
