package com.ellabook.util;

import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by mengxiangchao on 2017/11/22.
 */
public class VerifyUtil {

    /**
     * 是否位数字
     *
     * @param str
     * @return
     */
    public static boolean verifyNum(String str) {
        return verifyNum(str, 0);
    }

    /**
     * 整数或指定位数的小数
     *
     * @param str
     * @param n
     * @return
     */
    public static boolean verifyNum(String str, int n) {
        if (str != null) {
            String num = n < 2 ? "" : n + "";
            String regDecimal = "^[0-9]*(\\.[0-9]{1," + num + "})";
            String regInt = "^[0-9]*";
            Matcher md = Pattern.compile(regDecimal).matcher(str);
            Matcher mi = Pattern.compile(regInt).matcher(str);
            return md.matches() || mi.matches();
        } else {
            return false;
        }
    }

    public static String getAppointDigitsDecimal(String decimal, int digits) {
        BigDecimal bd = new BigDecimal(decimal);
        return bd.setScale(digits, BigDecimal.ROUND_HALF_UP).toString();
    }

    public static boolean isBlankList(List<?> list) {
        if (list == null || list.isEmpty()) {
            return true;
        } else {
            return false;
        }
    }

    public static boolean isBlankMap(Map<?, ?> map) {
        if (map == null || map.isEmpty()) {
            return true;
        } else {
            return false;
        }
    }

    public static boolean verifyBookCodePattern(String bookCode) {
        return Pattern.compile("^B[0-9]{12,25}").matcher(bookCode).matches();
    }

    public static boolean isBlankSet(Set<?> set) {
        if (set == null || set.isEmpty()) {
            return true;
        } else {
            return false;
        }
    }


    /**
     * 验证是否合法手机号：是否为11位纯数字且以13、14、15、17、18开头
     *
     * @param num
     * @return
     */
    public static boolean checkIsMobileNum(String num) {
        boolean result = true;
        Pattern p = Pattern.compile("^[1][3,4,5,6,7,8,9][0-9]{9}$"); // 验证手机号
        Matcher m = p.matcher(num);
        if (StringUtils.isBlank(num) || !(m.matches()) || !(num.length() == 11))
            result = false;
        return result;
    }

    public static boolean checkAllIsMobileNum(String num, String regularExpressions) {
        if (StringUtils.isAnyEmpty(num, regularExpressions)) {
            return false;
        }
        boolean result = true;
        Pattern p = Pattern.compile(regularExpressions); // 验证手机号
        Matcher m = p.matcher(num);
        if (StringUtils.isBlank(num) || !(m.matches()))
            result = false;
        return result;
    }

    public static Boolean checkEmail(String email) {
        if (email.matches("^\\w[-\\w.+]*@([A-Za-z0-9][-A-Za-z0-9]+\\.)+[A-Za-z]{2,14}$")) {
            return true;
        } else {
            return false;
        }
    }


}
