package com.ellabook.util;

import com.constants.LanguageConstant;
import com.ellabook.errorCode.UserErrorCode;
import com.github.houbb.opencc4j.util.ZhConverterUtil;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;

import static com.constants.BookCodeConstantUtil.*;
import static com.ellabook.errorCode.UserErrorCode.EMAIL_ERROR_CODE_DESC;

/**
 * @Author 孟阳
 */
public class TranslateMessageUtil {
    private final static Map<String, String> ENGLISH_MESSAGE_MAP = new HashMap<>();

    static {
        ENGLISH_MESSAGE_MAP.put("由于版权原因，非中国大陆地区暂无法购买及阅读", "Only available in mainland of China due to rights limitation");
        ENGLISH_MESSAGE_MAP.put("您可升级为连续包年会员，升级后将收取连续包年费用 $69.99 USD，当前会员服务到期后生效", "Upgrade membership to auto-renewal VIP with $69.99 annually now?");
        ENGLISH_MESSAGE_MAP.put("您是连续包年会员，服务变更后将收取连续包月费用$6.99 USD，当前会员服务到期后生效", "Change VIP to auto-renewal membership with $6.99 monthly after VIP expiration. ");
        ENGLISH_MESSAGE_MAP.put("取消", "Cancel");
        ENGLISH_MESSAGE_MAP.put("升级", "Upgrade");
        ENGLISH_MESSAGE_MAP.put("变更", "Change");
        ENGLISH_MESSAGE_MAP.put("升级会员", "Membership Upgrade");
        ENGLISH_MESSAGE_MAP.put("会员变更", "Membership Change");
        ENGLISH_MESSAGE_MAP.put("咿啦看书国际包月服务", "Monthly membership for Ella global site");
        ENGLISH_MESSAGE_MAP.put("咿啦看书国际包年服务", "VIP membership for Ella global site");
        ENGLISH_MESSAGE_MAP.put("首月免费，可随时取消", "1 month free,cancel any time");
        ENGLISH_MESSAGE_MAP.put("14天免费使用，可随时取消", "14 days free,cancel any time");
        ENGLISH_MESSAGE_MAP.put(MOBILENUM_ALREADY_REGIST_DESC, "The account has been registered!");
        ENGLISH_MESSAGE_MAP.put(EMAIL_ERROR_CODE_DESC, "Please enter the correct email account");
        ENGLISH_MESSAGE_MAP.put(USER_NOT_EXIST_DESC, "The account does not exists!");
        ENGLISH_MESSAGE_MAP.put(SMS_SEND_FAIL_DESC, "Send check code fail,please try again");
        ENGLISH_MESSAGE_MAP.put(SMS_LIMIT_DESC, "You can only send 1 check code per minute");
        ENGLISH_MESSAGE_MAP.put("请输入正确的手机号", "Please enter the correct mobile number");
        ENGLISH_MESSAGE_MAP.put("当前IP发送验证码今日已达上限，请更换手机号再试", "Upper limit of captcha");
        ENGLISH_MESSAGE_MAP.put(UserErrorCode.SMS_MOBILE_LIMIT_DESC, "Upper limit of captcha");
    }

    /**
     * @param language
     * @param message  英文的必须提前写好到对应的map中
     * @return
     */
    public static String translateMessage(String language, String message) {
        // 简体或为空
        if (StringUtils.isBlank(language) || StringUtils.equalsIgnoreCase(language, LanguageConstant.ZH_CN)) {
            return message;
        }
        //港澳台-繁体
        if (StringUtils.equalsIgnoreCase(LanguageConstant.ZH_FT, language)) {
            message = ZhConverterUtil.convertToTraditional(message, false);
        } else {
            //非繁体的全都是英文
            message = getEnglishMessageList(message);
        }
        return message;
    }

    private static String getEnglishMessageList(String key) {
        String message = ENGLISH_MESSAGE_MAP.get(key);
        return StringUtils.isBlank(message) ? key : message;
    }
}
