package com.ellabook.util;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.constants.BookRedisConstantUtil;
import com.ellabook.util.redis.RedisServiceUtil;
import com.ellabook.util.redis.RedisZoneEnum;
import org.apache.commons.collections.CollectionUtils;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RedisUtil {

    public static Map<String, Object> getBookPackageDetail(RedisServiceUtil redis, String code, String channelCode, int page, int pageSize) throws Exception {
        String fieldKey = channelCode + (page * pageSize + 1) + "-" + (page * pageSize <= 0 ? pageSize : (page + 1) * pageSize);
        return getBookPackageDetail(redis, code, fieldKey);
    }

    public static Map<String, Object> getBookPackageDetail(RedisServiceUtil redis, String code, int page, int pageSize) throws Exception {
        return getBookPackageDetail(redis, code, "", page, pageSize);
    }

    @SuppressWarnings("unchecked")
    private static Map<String, Object> getBookPackageDetail(RedisServiceUtil redis, String code, String fieldKey)
            throws Exception {
        Object obj = redis.getRedisTemplate(RedisZoneEnum.BOOK_PACKAGE).opsForHash().get(BookRedisConstantUtil.REDIS_BOOKPACKAGE_DETAIL + code, fieldKey);
        return JSONObject.parseObject((String) obj, Map.class);
    }

    public static void setBookPackageDetail(RedisServiceUtil redis, String code, String channelCode, int page, int pageSize, Object value) throws Exception {
        String fieldKey = channelCode + (page * pageSize + 1) + "-" + (page * pageSize <= 0 ? pageSize : (page + 1) * pageSize);
        redis.getRedisTemplate(RedisZoneEnum.BOOK_PACKAGE).opsForHash().put(BookRedisConstantUtil.REDIS_BOOKPACKAGE_DETAIL + code, fieldKey, JSONObject.toJSONString(value, SerializerFeature.WriteMapNullValue));
    }


    public static void setBookPackageDetail(RedisServiceUtil redis, String code, int page, int pageSize, Object value) throws Exception {
        setBookPackageDetail(redis, code, "", page, pageSize, value);
    }

    public static void delBookPackageDetail(RedisServiceUtil redis, String code) throws Exception {
        redis.getRedisTemplate(RedisZoneEnum.BOOK_PACKAGE).delete(BookRedisConstantUtil.REDIS_BOOKPACKAGE_DETAIL + code);
    }

    public static void delBookPackageDetail(RedisServiceUtil redis, Set<String> codes) throws Exception {
        Set<String> set = new HashSet<>();
        if (CollectionUtils.isNotEmpty(codes)) {
            codes.stream().forEach(code -> set.add(BookRedisConstantUtil.REDIS_BOOKPACKAGE_DETAIL + code));
        }
        redis.getRedisTemplate(RedisZoneEnum.BOOK_PACKAGE).delete(set);
    }

    @SuppressWarnings("unchecked")
    public static Map<String, Object> getBookCourseDetail(RedisServiceUtil redis, String courseCode, String resource) throws Exception {
        Object obj = redis.getRedisTemplate(RedisZoneEnum.BOOK_COURSE).opsForHash().get(BookRedisConstantUtil.REDIS_COURSE_DETAIL + courseCode, resource == null ? "" : resource);
        return JSONObject.parseObject((String) obj, Map.class);
    }

    public static void setBookCourseDetail(RedisServiceUtil redis, String courseCode, String resource, Object value) throws Exception {
        redis.getRedisTemplate(RedisZoneEnum.BOOK_COURSE).opsForHash().put(BookRedisConstantUtil.REDIS_COURSE_DETAIL + courseCode, resource, JSONObject.toJSONString(value, SerializerFeature.WriteMapNullValue));
    }

    public static void delBookCourseDetail(RedisServiceUtil redis, String code) throws Exception {
        redis.getRedisTemplate(RedisZoneEnum.BOOK_COURSE).delete(BookRedisConstantUtil.REDIS_COURSE_DETAIL + code);
    }

    public static void delBookCourseDetail(RedisServiceUtil redis, Set<String> courseCodes) throws Exception {
        Set<String> set = new HashSet<>();
        if (CollectionUtils.isNotEmpty(courseCodes)) {
            courseCodes.stream().forEach(code -> set.add(BookRedisConstantUtil.REDIS_COURSE_DETAIL + code));
        }
        redis.getRedisTemplate(RedisZoneEnum.BOOK_COURSE).delete(set);
    }

    /*public static List<BookCourseChapterIntroRelationVO> getChapterIntroRelation(String courseCode, String chapterCode) {
      String IntroRelation = redis.
    }*/
}
