package com.ellabook.util;

import org.apache.commons.lang3.StringUtils;
import org.junit.Test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

/**
 * Created by mengxiangchao on 2017/11/22.
 */
public class FileUtil {
    /**
     * 删除文件或文件夹
     *
     * @param path
     */
    public static void delFile(File path) {
        if (!path.exists())
            return;
        if (path.isFile()) {
            path.delete();
            return;
        }
        File[] files = path.listFiles();
        for (int i = 0; i < files.length; i++) {
            delFile(files[i]);
        }
        path.delete();
    }

    public static void delFile(String path) {
        delFile(getFile(path));
    }

    /**
     * 获取文件对象并创建指定文件路径
     *
     * @param path
     * @return
     */
    public static File getFile(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public static File createFile(String path) throws IOException {
        return createFile(path, "/");
    }

    public static File createFile(String path, String separator) throws IOException {
        getFile(path.substring(0, path.lastIndexOf(separator)));
        File newFile = new File(path);
        if (!newFile.exists())
            newFile.createNewFile();
        return newFile;
    }

    public static String getSuffix(String fileName) {
        if (StringUtils.isBlank(fileName)) {
            return null;
        }
        String[] split = fileName.split("\\.");
        String suffix = split[split.length - 1];
        return suffix;
    }

    public static List<File> getImgFileList(String strPath) {
        List<String> imageTypes = imageTypes();
        LinkedList<File> fileList = new LinkedList<>();
        File dir = new File(strPath);
        File[] files = dir.listFiles(); // 该文件目录下文件全部放入数组
        if (files != null) {
            for (int i = 0; i < files.length; i++) {
                String fileName = files[i].getName();
                if (files[i].isDirectory()) { // 判断是文件还是文件夹
                    fileList.addAll(getImgFileList(files[i].getAbsolutePath())); // 获取文件绝对路径
                } else if (imageTypes.contains(getSuffix(fileName))) { // 判断文件名是否以.avi结尾
                    fileList.add(files[i]);
                } else {
                    continue;
                }
            }

        }
        return fileList;
    }


    public static List<String> imageTypes() {
        ArrayList<String> imageTypes = new ArrayList<>();

        /*************************常见图片格式**********************/
        imageTypes.add("bmp");
        imageTypes.add("jpg");
        imageTypes.add("jpeg");
        imageTypes.add("png");
        imageTypes.add("gif");

        /*************************其他图片格式**********************/
        imageTypes.add("pcx");
        imageTypes.add("tiff");
        imageTypes.add("tga");
        imageTypes.add("exif");
        imageTypes.add("fpx");
        imageTypes.add("svg");
        imageTypes.add("psd");
        imageTypes.add("cdr");
        imageTypes.add("pcd");
        imageTypes.add("dxf");
        imageTypes.add("ufo");
        imageTypes.add("eps");
        imageTypes.add("ai");
        imageTypes.add("hdri");
        imageTypes.add("raw");
        imageTypes.add("wmf");
        imageTypes.add("lic");
        imageTypes.add("emf");
        return imageTypes;
    }


    public static List<String> videoTypes() {
        ArrayList<String> videoTypes = new ArrayList<>();
        videoTypes.add("wav");
        videoTypes.add("mp3");
        videoTypes.add("aif");
        videoTypes.add("cda");
        videoTypes.add("mid");
        videoTypes.add("wma");
        return videoTypes;
    }


    /**
     * 创建多级文件目录
     *
     * @param file
     */
    public static void mkDir(File file) {
        if (file.getParentFile().exists()) {
            file.mkdir();
        } else {
            mkDir(file.getParentFile());
            file.mkdir();
        }
    }

    /**
     * 文件写入文件（追加）
     *
     * @param fileName
     * @param content
     */
    public static void writeToFile(String path, String fileName, String content) {
        try {
            File file = new File(path);
            mkDir(file); //创建文件夹
            FileWriter writer = new FileWriter(path + "/" + fileName, true);
            if (content != null && !content.equals("")) {
                writer.write(content);
            }
            writer.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void compress(File sourceFile, ZipOutputStream zos, String name, boolean KeepDirStructure) throws Exception {
        byte[] buf = new byte[2 * 1024];
        if (sourceFile.isFile()) {
            // 向zip输出流中添加一个zip实体，构造器中name为zip实体的文件的名字
            zos.putNextEntry(new ZipEntry(name));
            // copy文件到zip输出流中
            int len;
            FileInputStream in = new FileInputStream(sourceFile);
            while ((len = in.read(buf)) != -1) {
                zos.write(buf, 0, len);
            }
            // Complete the entry
            zos.closeEntry();
            in.close();
        } else {
            File[] listFiles = sourceFile.listFiles();
            if (listFiles == null || listFiles.length == 0) {
                // 需要保留原来的文件结构时,需要对空文件夹进行处理
                if (KeepDirStructure) {
                    // 空文件夹的处理
                    zos.putNextEntry(new ZipEntry(name + "/"));
                    // 没有文件，不需要文件的copy
                    zos.closeEntry();
                }
            } else {
                for (File file : listFiles) {
                    // 判断是否需要保留原来的文件结构
                    if (KeepDirStructure) {
                        // 注意：file.getName()前面需要带上父文件夹的名字加一斜杠,
                        // 不然最后压缩包中就不能保留原来的文件结构,即：所有文件都跑到压缩包根目录下了
                        compress(file, zos, name + "/" + file.getName(), KeepDirStructure);
                    } else {
                        compress(file, zos, file.getName(), KeepDirStructure);
                    }
                }
            }
        }
    }

    @Test
    public void testStr() {
        writeToFile("E:/et/e/et/rt", "test.txt", "1\n");
    }
}
