package com.ellabook.util;

import java.util.Random;

public class CreateRedeemCodeUtil {

    /***
     * 产生随机数的方法
     *
     * @param length
     * @return
     */
    public static String getCharAndNumr(int length) {
        if (length >= 3) {
            String val = "";
            int bound = 0;
            Random random = new Random();
            for (int i = 0; i < length; i++) {
                String charOrNum = random.nextInt(2) % 2 == 0 ? "char" : "num"; // 输出字母还是数字
                // 产生的是字母
                if ("char".equalsIgnoreCase(charOrNum)) // 字符串
                {
                    do {
                        bound = random.nextInt(26);
                    } while (bound == 8 || bound == 14);//出去i和o
                    val += (char) (65 + bound);
                }
                // 产生的是数字
                else if ("num".equalsIgnoreCase(charOrNum)) // 数字
                {
                    do {
                        bound = random.nextInt(10);
                    } while (bound < 2);//除去0和1
                    val += String.valueOf(bound);
                }
            }
            return val;
        } else {
            return null;
        }
    }

    /***
     * 用来处理长度不符合要求的情况
     *
     * @param rcs
     * @return
     */
    public static String check(String rcs) {
        java.util.Scanner sc = new java.util.Scanner(System.in);
        String val = null;
        if (rcs == null) {
            rcs = getCharAndNumr(sc.nextInt()); // 调用随机数的方法
            val = check(rcs); // 递归调用字符是否符合要求
        } else {
            val = rcs;
        }
        return val;
    }

    /****
     * 主函数方法
     *
     * @param length
     */
    public static String getRedeemCode(Integer length) {
        return check(getCharAndNumr(length)); // 得到随机数
    }

}
