package com.ellabook.util;

import org.apache.commons.lang3.StringUtils;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * Created by mengxiangchao on 2017/12/5.
 */
public class CodeUtil {
    private SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmm");
    private Date date = new Date();
    private String saveDate;
    private String saveIncr;
    private String saveIncrRecord;

    public CodeUtil(String saveDate, String saveIncr, String saveIncrRecord) {
        this.saveDate = saveDate;
        this.saveIncr = saveIncr;
        this.saveIncrRecord = saveIncrRecord;
    }

    public void setSaveDate(String saveDate) {
        this.saveDate = saveDate;
    }

    public void setSaveIncr(String saveIncr) {
        this.saveIncr = saveIncr;
    }

    public void setSaveIncrRecord(String saveIncrRecord) {
        this.saveIncrRecord = saveIncrRecord;
    }

    public String getSaveDate() {
        return saveDate;
    }

    public String getSaveIncr() {
        return saveIncr;
    }

    public String getSaveIncrRecord() {
        return saveIncrRecord;
    }

    public CodeUtil invoke() {
        saveIncrRecord = StringUtils.isBlank(saveIncrRecord) ? "0" : saveIncrRecord;
        if (StringUtils.isBlank(saveDate)) {
            saveDate = format.format(date);
        }
        if (StringUtils.isBlank(saveIncr)) {
            saveIncr = "0";
        }
        long a = Long.parseLong(saveDate);
        long b = Long.parseLong(format.format(date));
        if (a > b) {
            throw new RuntimeException("时间倒转，可能会生成重复的Code码，请校正系统时间！");
        }
        if (a < b) {
            long c = Long.parseLong(saveIncr);
            long d = Long.parseLong(saveIncrRecord);
            if (c > 60000 + d) {
                d = (60000 + d) - c;
            } else {
                d = 0;
            }
            saveDate = format.format(date);
            saveIncr = "0";
            saveIncrRecord = d + "";
        }
        return this;
    }
}