package com.ellabook.push;

import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.json.JSONObject;
import org.springframework.util.DigestUtils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class PushClient {

    // The user agent
    protected final String USER_AGENT = "Mozilla/5.0";

    // This object is used for sending the post request to Umeng
    protected HttpClient client = HttpClientBuilder.create().build();

    // The host
    protected static final String host = "http://msg.umeng.com";

    // The upload path
    protected static final String uploadPath = "/upload";

    // The post path
    protected static final String postPath = "/api/send";

    public boolean send(UmengNotification msg) {
        boolean results = false;
        BufferedReader rd = null;
        try {
            String timestamp = Integer.toString((int) (System.currentTimeMillis() / 1000));
            msg.setPredefinedKeyValue("timestamp", timestamp);
            String url = host + postPath;
            String postBody = msg.getPostBody();
            String sign = DigestUtils.md5DigestAsHex(("POST" + url + postBody + msg.getAppMasterSecret()).getBytes("utf8"));
            url = url + "?sign=" + sign;
            HttpPost post = new HttpPost(url);
            post.setHeader("User-Agent", USER_AGENT);
            StringEntity se = new StringEntity(postBody, "UTF-8");
            post.setEntity(se);
            // Send the post request and get the response
            HttpResponse response = client.execute(post);
            int status = response.getStatusLine().getStatusCode();
            rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            StringBuffer result = new StringBuffer();
            String line = "";
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
            if (status == 200) {
                results = true;
            } else {
                System.out.println("Failed to send the notification!");
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                if (rd != null)
                    rd.close();
            } catch (IOException e) {
                e.printStackTrace();

            }
        }

        return results;
    }

    // Upload file with device_tokens to Umeng
    public String uploadContents(String appkey, String appMasterSecret, String contents) {
        String fileId = null;
        BufferedReader rd = null;
        try {
            // Construct the json string
            JSONObject uploadJson = new JSONObject();
            uploadJson.put("appkey", appkey);
            String timestamp = Integer.toString((int) (System.currentTimeMillis() / 1000));
            uploadJson.put("timestamp", timestamp);
            uploadJson.put("content", contents);
            // Construct the request
            String url = host + uploadPath;
            String postBody = uploadJson.toString();
            String sign = DigestUtils.md5DigestAsHex(("POST" + url + postBody + appMasterSecret).getBytes("utf8"));
            url = url + "?sign=" + sign;
            HttpPost post = new HttpPost(url);
            post.setHeader("User-Agent", USER_AGENT);
            StringEntity se = new StringEntity(postBody, "UTF-8");
            post.setEntity(se);
            // Send the post request and get the response
            HttpResponse response = client.execute(post);
            rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            StringBuffer result = new StringBuffer();
            String line = "";
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
            // Decode response string and get file_id from it
            JSONObject respJson = new JSONObject(result.toString());
            String ret = respJson.getString("ret");
            if (!"SUCCESS".equals(ret)) {
                throw new Exception("Failed to upload file");
            }
            JSONObject data = respJson.getJSONObject("data");
            fileId = data.getString("file_id");
            // Set file_id into rootJson using setPredefinedKeyValue
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                if (rd != null)
                    rd.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return fileId;
    }

}
