package com.ellabook.point;

import java.math.BigDecimal;

public enum PointOperationEnum {

    /**
     * 任务奖励获取积分
     */
    TASK_REWARD(BigDecimal.ONE, "TASK_REWARD", "GET", "积分奖励"),
    /**
     * 积分支付操作
     */
    PAY(BigDecimal.valueOf(-1), "PAY", "USE", "积分支付");

    private PointOperationEnum(BigDecimal operation, String code, String useType, String description) {
        this.operation = operation;
        this.code = code;
        this.useType = useType;
        this.description = description;
    }

    private BigDecimal operation;

    private String code;

    private String useType;

    private String description;

    public BigDecimal getOperation() {
        return operation;
    }

    public String getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    public String getUseType() {
        return useType;
    }

}
