package com.ellabook.pay;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by xixiaoyi on 2018/08/21.
 */
public class ApplePayConfig {
    /**
     * 沙盒环境支付凭证校验地址
     */
    public static final String APPLE_PAY_CHECK_URL_SANDBOX = "https://sandbox.itunes.apple.com/verifyReceipt";
    /**
     * 生产环境支付凭证校验地址
     */
    public static final String APPLE_PAY_CHECK_URL_VERIFY = "https://buy.itunes.apple.com/verifyReceipt";
    /**
     * 生产环境支付凭证校验密码
     */
    public static final String APPLE_PAY_SHARE_SECRET_KEY = "5265799013ee4b339550eb78d4583059";
    /**
     * 表示续订状态有改变。可检查auto_renew_status_change_date_ms和auto_renew_status字段
     */
    public static final String DID_CHANGE_RENEWAL_STATUS = "DID_CHANGE_RENEWAL_STATUS";
    /**
     * 表示用户退款了或者用户升级了订阅。（用户升级订阅后，会退款之前的订阅）
     */
    public static final String CANCEL = "CANCEL";
    /**
     * 表示用户更改订阅计划，会在下次订阅生效。对当前订阅无影响。
     */
    public static final String DID_CHANGE_RENEWAL_PREF = "DID_CHANGE_RENEWAL_PREF";
    /**
     * 表示由于账单问题，续订失败。可检查 is_in_billing_retry_period
     */
    public static final String DID_FAIL_TO_RENEW = "DID_FAIL_TO_RENEW";
    /**
     * 表示成功续订。这个是针对过去续订失败的订阅。
     */
    public static final String DID_RECOVER = "DID_RECOVER";
    /**
     * 表示第一次订阅。
     */
    public static final String INITIAL_BUY = "INITIAL_BUY";
    /**
     * 表示用户手动续订成功
     */
    public static final String INTERACTIVE_RENEWAL = "INTERACTIVE_RENEWAL";
    /**
     * 表示自动续订成功。（此字段苹果计划废弃，用DID_RECOVER代替。）
     */
    public static final String RENEWAL = "RENEWAL";
    /**
     * IOS支付bid
     */
    public static final String APPLE_PAY_BID_APP = "com.diandu.ellabook";
    /**
     * IOS HD支付bid
     */
    public static final String APPLE_PAY_BID_HD = "com.diandu.ellabookHD";
    /**
     * IOS-APP连续包月-国内
     */
    public static final String APPLE_PAY_PRODUCT_ID_APP_28 = "ellabook2monthcardAuto01";
    /**
     * IOS-APP连续包月-国内
     */
    public static final String APPLE_PAY_PRODUCT_ID_APP_40 = "ellabook2monthcardAuto02";

    /**
     * IOS-APP连续包月-海外
     */
    public static final String APPLE_PAY_PRODUCT_ID_APP_US_50 = "ellabook2monthcardAuto03";


    /**
     * IOS-HD连续包月-国内
     */
    public static final String APPLE_PAY_PRODUCT_ID_HD = "ellabookHDmonthcardAuto01";

    /**
     * IOS-HD连续包月-国内
     */
    public static final String APPLE_PAY_PRODUCT_ID_HD_40 = "ellabookHDmonthcardAuto040";

    /**
     * IOS-HD连续包月-海外
     */
    public static final String APPLE_PAY_PRODUCT_ID_HD_US_50 = "ellabookHDmonthcardAuto03";

    /**
     * IOS-APP连续包年-海外 $69.99
     */
    public static final String APPLE_PAY_PRODUCT_ID_APP_YEAR = "ellabook2yearcardAuto01";
    /**
     * IOS-HD连续包年-海外 $69.99
     */
    public static final String APPLE_PAY_PRODUCT_ID_HD_YEAR = "ellabookHDyearcardAuto01";
    /**
     * IOS-连续包月（首月免费）-海外 $6.99
     */
    public static final String APPLE_PAY_PRODUCT_ID_FIRST_MONTH_FREE_MONTH = "ellabook2monthcardAuto04";
    /**
     * IOS-连续包年（首月免费）-海外 $69.99
     */
    public static final String APPLE_PAY_PRODUCT_ID_FIRST_MONTH_FREE_YEAR = "ellabook2yearcardAuto04";

    /**
     * IOS-HD连续包月（首月免费）-海外 $6.99
     */
    public static final String APPLE_PAY_PRODUCT_ID_HD_FIRST_MONTH_FREE_MONTH = "ellabookHDmonthcardAuto04";
    /**
     * IOS-HD连续包年（首月免费）-海外 $69.99
     */
    public static final String APPLE_PAY_PRODUCT_ID_HD_FIRST_MONTH_FREE_YEAR = "ellabookHDyearcardAuto04";
    /**
     * IOS-连续包月（前2周免费）-海外 $6.99
     */
    public static final String APPLE_PAY_PRODUCT_ID_FIRST_2WEEK_FREE_MONTH = "ellabook2monthcardAuto05";
    /**
     * IOS-连续包年（前2周免费）-海外 $69.99
     */
    public static final String APPLE_PAY_PRODUCT_ID_FIRST_2WEEK_FREE_YEAR = "ellabook2yearcardAuto05";
    /**
     * IOS-HD连续包月（前2周免费）-海外 $6.99
     */
    public static final String APPLE_PAY_PRODUCT_ID_HD_FIRST_2WEEK_FREE_MONTH = "ellabookHDmonthcardAuto05";
    /**
     * IOS-HD连续包年（前2周免费）-海外 $69.99
     */
    public static final String APPLE_PAY_PRODUCT_ID_HD_FIRST_2WEEK_FREE_YEAR = "ellabookHDyearcardAuto05";

    /**
     * 版本2.7.9 IOS-APP 连续包月（前1周免费）-海外 $6.99
     */
    public static final String APPLE_PAY_PRODUCT_ID_HD_FIRST_1WEEK_FREE_MONTH = "ellabook2monthcardAuto06";

    /**-----------------------------------海外版本独立部署-------------------------------------------------*/
    /**
     * 独立部署海外版 3.0.0 IOS-APP 连续包月 $6.99
     */
    public static final String APPLE_PAY_PRODUCT_ID_APP_OVERSEAS_AUTO_MONTH = "ellabookoverseasmonthcardAuto01";
    /**
     * 独立部署海外版 3.0.0 IOS-APP 连续包月首周免费 $6.99
     */
    public static final String APPLE_PAY_PRODUCT_ID_APP_OVERSEAS_AUTO_FIRST_1WEEK_FREE_MONTH = "ellabookoverseasmonthcardAuto02";
    /**
     * 独立部署海外版 3.0.0 IOS-APP 连续包月首月免费 $6.99
     */
    public static final String APPLE_PAY_PRODUCT_ID_APP_OVERSEAS_AUTO_FIRST_MONTH_FREE_MONTH = "ellabookoverseasmonthcardAuto03";
    /**
     * 独立部署海外版 3.0.0 IOS-APP 月卡 $6.99
     */
    public static final String APPLE_PAY_PRODUCT_ID_APP_OVERSEAS_MONTH = "ellabookoverseasmonthcard04";

    /**
     * 独立部署海外版 3.0.0 IOS-APP 连续包年 $69.99
     */
    public static final String APPLE_PAY_PRODUCT_ID_APP_OVERSEAS_AUTO_YEAR = "ellabookoverseasyearscardAuto01";
    /**
     * 独立部署海外版 3.0.0 IOS-APP 连续包年前两周免费 $69.99
     */
    public static final String APPLE_PAY_PRODUCT_ID_APP_OVERSEAS_AUTO_FIRST_2WEEK_FREE_YEAR = "ellabookoverseasyearscardAuto02";
    /**
     * 独立部署海外版 3.0.0 IOS-APP 连续包年首月免费 $69.99
     */
    public static final String APPLE_PAY_PRODUCT_ID_APP_OVERSEAS_AUTO_FIRST_MONTH_FREE_YEAR = "ellabookoverseasyearscardAuto03";
    /**
     * 独立部署海外版 3.0.0 IOS-APP 年卡 $69.99
     */
    public static final String APPLE_PAY_PRODUCT_ID_APP_OVERSEAS_YEAR = "ellabookoverseasyearscard04";

    public static Map<String, String> getAutoVipMap() {
        Map<String, String> map = new HashMap<>(32);
        map.put(APPLE_PAY_PRODUCT_ID_APP_28, APPLE_PAY_PRODUCT_ID_APP_28);
        map.put(APPLE_PAY_PRODUCT_ID_APP_40, APPLE_PAY_PRODUCT_ID_APP_40);
        map.put(APPLE_PAY_PRODUCT_ID_APP_US_50, APPLE_PAY_PRODUCT_ID_APP_US_50);
        map.put(APPLE_PAY_PRODUCT_ID_HD, APPLE_PAY_PRODUCT_ID_HD);
        map.put(APPLE_PAY_PRODUCT_ID_HD_40, APPLE_PAY_PRODUCT_ID_HD_40);
        map.put(APPLE_PAY_PRODUCT_ID_HD_US_50, APPLE_PAY_PRODUCT_ID_HD_US_50);
        map.put(APPLE_PAY_PRODUCT_ID_APP_YEAR, APPLE_PAY_PRODUCT_ID_APP_YEAR);
        map.put(APPLE_PAY_PRODUCT_ID_HD_YEAR, APPLE_PAY_PRODUCT_ID_HD_YEAR);
        map.put(APPLE_PAY_PRODUCT_ID_FIRST_MONTH_FREE_MONTH, APPLE_PAY_PRODUCT_ID_FIRST_MONTH_FREE_MONTH);
        map.put(APPLE_PAY_PRODUCT_ID_FIRST_MONTH_FREE_YEAR, APPLE_PAY_PRODUCT_ID_FIRST_MONTH_FREE_YEAR);
        map.put(APPLE_PAY_PRODUCT_ID_HD_FIRST_MONTH_FREE_MONTH, APPLE_PAY_PRODUCT_ID_HD_FIRST_MONTH_FREE_MONTH);
        map.put(APPLE_PAY_PRODUCT_ID_HD_FIRST_MONTH_FREE_YEAR, APPLE_PAY_PRODUCT_ID_HD_FIRST_MONTH_FREE_YEAR);
        map.put(APPLE_PAY_PRODUCT_ID_FIRST_2WEEK_FREE_MONTH, APPLE_PAY_PRODUCT_ID_FIRST_2WEEK_FREE_MONTH);
        map.put(APPLE_PAY_PRODUCT_ID_FIRST_2WEEK_FREE_YEAR, APPLE_PAY_PRODUCT_ID_FIRST_2WEEK_FREE_YEAR);
        map.put(APPLE_PAY_PRODUCT_ID_HD_FIRST_2WEEK_FREE_MONTH, APPLE_PAY_PRODUCT_ID_HD_FIRST_2WEEK_FREE_MONTH);
        map.put(APPLE_PAY_PRODUCT_ID_HD_FIRST_2WEEK_FREE_YEAR, APPLE_PAY_PRODUCT_ID_HD_FIRST_2WEEK_FREE_YEAR);
        map.put(APPLE_PAY_PRODUCT_ID_HD_FIRST_1WEEK_FREE_MONTH, APPLE_PAY_PRODUCT_ID_HD_FIRST_1WEEK_FREE_MONTH);

        //海外版本独立部署  ios_price_code 月卡
        map.put(APPLE_PAY_PRODUCT_ID_APP_OVERSEAS_AUTO_MONTH, APPLE_PAY_PRODUCT_ID_APP_OVERSEAS_AUTO_MONTH);
        map.put(APPLE_PAY_PRODUCT_ID_APP_OVERSEAS_AUTO_FIRST_1WEEK_FREE_MONTH, APPLE_PAY_PRODUCT_ID_APP_OVERSEAS_AUTO_FIRST_1WEEK_FREE_MONTH);
        map.put(APPLE_PAY_PRODUCT_ID_APP_OVERSEAS_AUTO_FIRST_MONTH_FREE_MONTH, APPLE_PAY_PRODUCT_ID_APP_OVERSEAS_AUTO_FIRST_MONTH_FREE_MONTH);
        map.put(APPLE_PAY_PRODUCT_ID_APP_OVERSEAS_MONTH, APPLE_PAY_PRODUCT_ID_APP_OVERSEAS_MONTH);

        //海外版本独立部署  ios_price_code 年卡
        map.put(APPLE_PAY_PRODUCT_ID_APP_OVERSEAS_AUTO_YEAR, APPLE_PAY_PRODUCT_ID_APP_OVERSEAS_AUTO_YEAR);
        map.put(APPLE_PAY_PRODUCT_ID_APP_OVERSEAS_AUTO_FIRST_2WEEK_FREE_YEAR, APPLE_PAY_PRODUCT_ID_APP_OVERSEAS_AUTO_FIRST_2WEEK_FREE_YEAR);
        map.put(APPLE_PAY_PRODUCT_ID_APP_OVERSEAS_AUTO_FIRST_MONTH_FREE_YEAR, APPLE_PAY_PRODUCT_ID_APP_OVERSEAS_AUTO_FIRST_MONTH_FREE_YEAR);
        map.put(APPLE_PAY_PRODUCT_ID_APP_OVERSEAS_YEAR, APPLE_PAY_PRODUCT_ID_APP_OVERSEAS_YEAR);
        return map;
    }

}
