package com.ellabook.mq.message;

import com.ellabook.entity.order.OrderDetail;
import com.ellabook.entity.order.OrderHeader;
import com.ellabook.entity.order.VipCardConfig;
import com.ellabook.mq.BaseMsg;
import com.ellabook.mq.MsgTagEnum;
import lombok.*;

/**
 * @author D-L
 * @version 1.0.0
 * @ClassName SynOrderAndVipEndTimeMsg.java
 * @Description 处理海外用户连续付费会员订单和会员时长 实体
 * @createTime 2021-07-01 16:18:00
 */

@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class SynOrderAndVipEndTimeMsg extends BaseMsg {
    //消息Id
    private String id;

    //账户uid
    private String uid;

    //会员配置信息
    private VipCardConfig vipCardConfig;

    //订单记录表信息
    private OrderHeader orderHeader;

    //订单详情
    private OrderDetail orderDetail;

    @Override
    public String getTag() {
        return MsgTagEnum.SYN_SEND_ORDER_VIP_END_TIME.getTag();
    }
}
