package com.ellabook.mq.message;

import com.ellabook.mq.BaseMsg;
import com.ellabook.mq.MsgTagEnum;
import lombok.*;

/**
 * 阅读总时长
 *
 * @author xiaomo
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ReadBookTotalTimeMsg extends BaseMsg {

    /**
     * 消息Id
     */
    private String id;

    /**
     * 用户ID
     */
    private String uid;

    /**
     * 图书编码
     */
    private String bookCode;

    @Override
    public String getTag() {
        return MsgTagEnum.READ_BOOK_TOTAL_TIME.getTag();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getUid() {
        return this.uid;
    }
}
