package com.ellabook.mq.message;

import com.ellabook.mq.BaseMsg;
import com.ellabook.mq.MsgTagEnum;
import lombok.*;

import java.math.BigDecimal;

/**
 * 单本图书阅读消息
 *
 * @author maofengHan
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ReadBookMsg extends BaseMsg {

    /**
     * 消息Id
     */
    private String id;

    /**
     * 用户ID
     */
    private String uid;

    /**
     * 图书编码
     */
    private String bookCode;


    private long bookId;

    @Override
    public String getTag() {
        return MsgTagEnum.READ_BOOK.getTag();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getUid() {
        return this.uid;
    }
}
