package com.ellabook.mq.message;

import com.ellabook.mq.BaseMsg;
import com.ellabook.mq.MsgTagEnum;

import lombok.*;

@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class LoginMsg extends BaseMsg {
    private String id;
    private String uid;
    /**
     * 用户孩子ID
     */
    private String cid;
    private String uname;
    private boolean success;

    /**
     * 客户端版本号
     */
    private String clientVersion;

    @Override
    public String getTag() {
        return MsgTagEnum.LOGIN.getTag();
    }

    @Override
    public String getId() {
        return this.id;
    }


    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public String getCid() {
        return this.cid;
    }

    @Override
    public String getClientVersion() {
        return this.clientVersion;
    }
}
