package com.ellabook.mq.message;

import com.ellabook.mq.BaseMsg;
import com.ellabook.mq.MsgTagEnum;
import lombok.*;

/**
 * 听书时长消息
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ListenAudioBookTimeMsg extends BaseMsg {

    /**
     * 消息ID
     */
    private String id;

    /**
     * 用户ID
     */
    private String uid;

    /**
     * 用户孩子ID
     */
    private String cid;

    /**
     * 音频编码
     */
    private String audioCode;

    /**
     * 听书时长
     */
    private int listenTime;
    /**
     * 客户端版本号
     */
    private String clientVersion;

    @Override
    public String getTag() {
        return MsgTagEnum.LISTEN_AUDIO_BOOK_TIME.getTag();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public String getCid() {
        return this.cid;
    }

    @Override
    public String getClientVersion() {
        return this.clientVersion;
    }
}
