package com.ellabook.mq.message;

import com.ellabook.mq.BaseMsg;
import com.ellabook.mq.MsgTagEnum;
import lombok.*;

import java.math.BigDecimal;

/**
 * 图书包购买成功消息
 *
 * @author maofengHan
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class BuyBookPackageMsg extends BaseMsg {

    /**
     * 消息ID，支付成功订单编号
     */
    private String id;

    /**
     * 用户ID
     */
    private String uid;

    /**
     * 图书包编码
     */
    private String packageCode;

    /**
     * 订单编号
     */
    private String orderNo;

    /**
     * 实际支付金额
     */
    private BigDecimal amount;

    /**
     * 红包金额
     */
    private BigDecimal couponAmount;

    /**
     * 平台（ANDROID，IOS）
     */
    private String resource;

    private boolean isTrigger;

    @Override
    public String getTag() {
        return MsgTagEnum.BUY_BOOK_PACKAGE.getTag();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getUid() {
        return this.uid;
    }
}
