package com.ellabook.mq.message;

import com.ellabook.mq.BaseMsg;
import com.ellabook.mq.MsgTagEnum;
import lombok.*;

@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class BbkSendToParentMsg extends BaseMsg {
    private String id; //BBK账号
    private String uid;
    private String orderId;
    private String machineId;
    private String categoryAttribute;
    private String proxyPayUrl;

    @Override
    public String getTag() {
        return MsgTagEnum.BBK_SEND_PARENT_ORDER.getTag();
    }


    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getUid() {
        return this.uid;
    }
}
