package com.ellabook.mq.message;

import com.ellabook.mq.BaseMsg;
import com.ellabook.mq.MsgTagEnum;
import lombok.*;

@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class BbkBookSyncMsg extends BaseMsg {
    private String id;
    private String uid;
    private String bookCode;
    private String syncType;
    private String openId;
    private String type;// 1-绘本 2-故事

    @Override
    public String getTag() {
        return MsgTagEnum.BBK_BOOK_SYNC.getTag();
    }


    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getUid() {
        return this.uid;
    }
}
