package com.ellabook.errorCode;

public interface OperationErrorCode {
    /****************** 接口调用描述  *****************/
    String SUCCESS_DESCRIBE = "【调用成功】";
    String FAIL_DESCRIBE = "【调用失败】";


    /****************** 系统状态(status) *****************/
    String STATUS_SUCCESS = "1"; // 成功
    String STATUS_FAIL = "0"; // 失败


    /*************** 系统错误码(code) ******************/
    String SYSTEM_SUCCESS = "0x0000000"; // 成功
    String SYSTEM_EXCEPTION = "10000001"; // 系统异常
    String API_NOT_EXIST = "10000002"; // API 不存在

    /************** 参数校验(param)**********************/
    String ERROR_PARAM_CODE = "20000001";
    String ERROR_PARAM_DESC = "参数错误";
    String WEB_EXCEPTION = "20000002"; // API 不存在
    String WEB_EXCEPTION_DESC = "网络请求异常"; // API 不存在
    /*************** 业务级错误(code) ******************/
    String SHELVES_FAIL_CODE = "30000001";
    String SHELVES_FAIL_DESC = "商品上下架失败";

    public static final String OPERATION_OVERLAP_CODE = "30000002";
    public static final String OPERATION_OVERLAP_DESC = "操作过于频繁";

    String THIRDCODE_OCCUPY = "30000003";
    String THIRDCODE_OCCUPY_DESC = "该物品已被占用";

    String RESOURCE_ALREADY_EXCITED = "30000004";
    String RESOURCE_ALREADY_EXCITED_DESC = "资源已存在";

    String AUTHOR_ALREADY_USE = "30000005";
    String AUTHOR_ALREADY_USE_DESC = "作者已被使用，不能删除";

    String AUTHOR_ALREADY_EXIST = "30000006";
    String AUTHOR_ALREADY_EXIST_DESC = "该作者已存在";

    /**************** 红包活动错误码 ********************/
    String COUPON_ACTIVITY_NOT_EXIST = "40000001";
    String COUPON_ACTIVITY_NOT_EXIST_DESC = "该红包活动不存在";
    String REGISTER_COUPON_ACTIVITY_HAS_EXIST = "40000002";
    //    String REGISTER_COUPON_ACTIVITY_HAS_EXIST_DESC = "该渠道已存在注册送红包活动";
    String REGISTER_COUPON_ACTIVITY_HAS_EXIST_DESC = "该渠道当前时间段已存在注册送红包活动";
    String COUPON_ACTIVITY_HAD_JOINED = "40000003";
    String COUPON_ACTIVITY_HAD_JOINED_DESC = "该用户已参加活动";
    String COUPON_ACTIVITY_HAD_FINISH = "40000004";
    String COUPON_ACTIVITY_HAD_FINISH_DESC = "红包已领完";
    String COUPON_ACTIVITY_CHANNEL_CODE_NOT_EXIST = "40000005";
    String COUPON_ACTIVITY_CHANNEL_CODE_NOT_EXIST_DESC = "该红包活动渠道不可为空";

    /***************** 赠书活动错误码 *******************/
    String SEND_BOOK_ACTIVITY_NOT_EXIST = "50000001";
    String SEND_BOOK_ACTIVITY_NOT_EXIST_DESC = "该送书活动不存在";
    String REGISTER_SEND_BOOK_ACTIVITY_HAS_EXIST = "50000002";
    //    String REGISTER_SEND_BOOK_ACTIVITY_HAS_EXIST_DESC = "该渠道已存在注册送书活动";
    String REGISTER_SEND_BOOK_ACTIVITY_HAS_EXIST_DESC = "该渠道当前时间段已存在注册送书活动";
    String SEND_BOOK_ACTIVITY_UPPER_LIMIT = "50000003";
    String SEND_BOOK_ACTIVITY_UPPER_LIMIT_DESC = "该活动参与人数已达上限";
    String SEND_BOOK_ACTIVITY_CHANNEL_CODE_NOT_EXIST = "50000004";
    String SEND_BOOK_ACTIVITY_CHANNEL_CODE_NOT_EXIST_DESC = "该送书活动渠道不可为空";
    String IP_CARD_ACTIVITY_NOT_EXIST = "50000005";
    String IP_CARD_ACTIVITY_NOT_EXIST_DESC = "该ip卡与当前活动不匹配";

    String SEND_BOOK_ACTIVITY_WAITING = "50000006";
    String SEND_BOOK_ACTIVITY_WAITING_DESC = "该送书活动尚未开始";
    String SEND_BOOK_ACTIVITY_FINISHED = "50000007";
    String SEND_BOOK_ACTIVITY_FINISHED_DESC = "该送书活动尚已结束";
    String SEND_BOOK_ACTIVITY_EXPIRED = "50000008";
    String SEND_BOOK_ACTIVITY_EXPIRED_DESC = "该送书活动已过期";

    String INSERT_IDFA_FAIL = "50000009";
    String INSERT_IDFA_FAIL_DESC = "此IDFA未激活成功";

    String IDFA_ALREADY_EXISTED = "50000010";
    String IDFA_ALREADY_EXISTED_DESC = "此IDFA已存在";

    String IDFA_REPORT_FAIL = "50000011";
    String IDFA_REPORT_FAIL_DESC = "此IDFA上报失败";


    /*口令活动*/
    String WATCHWORD_ACTIVITY_INFO_ERR = "50000011";
    String WATCHWORD_ACTIVITY_INFO_ERR_DESC = "该口令活动信息错误";
    String WATCHWORD_CODE_ALREADY_EXISTED = "50000012";
    String WATCHWORD_CODE_ALREADY_EXISTED_DESC = "该口令码已存在";
    String WATCHWORD_ACTIVITY_NOT_EXIST = "50000013";
    String WATCHWORD_ACTIVITY_NOT_EXIST_DESC = "该口令活动不存在";

    String SIGN_ACTIVITY_NOT_EXIST = "60000001";
    String SIGN_ACTIVITY_NOT_EXIST_DESC = "当前没有签到活动，尽请期待";

    String SIGN_ACTIVITY_JOIN_FAIL = "60000002";
    String SIGN_ACTIVITY_JOIN_FAIL_DESC = "该签到活动参加失败，请稍后再试";

    String SIGN_ACTIVITY_HAD_JOINED = "60000003";
    String SIGN_ACTIVITY_HAD_JOINED_DESC = "该签到活动您已参加，快去咿啦看书APP签到吧";

    String SIGN_ACTIVITY_FINISHED = "60000004";
    String SIGN_ACTIVITY_FINISHED_DESC = "该签到活动已结束";

    String TODAY_ACTIVITY_SIGN = "60000005";
    String TODAY_ACTIVITY_SIGN_DESC = "您今日该活动已签到，请勿重复签到";


    /**************** 通知错误码 ********************/
    String ADVICE_TIME_INTERVAL_CROSS = "70000001";
    String ADVICE_TIME_INTERVAL_CROSS_DESC = "通知起止时间与已有其他通知存在交叉！";
    String ADVICE_TIME_INTERVAL_ERROR = "70000002";
    String ADVICE_TIME_INTERVAL_ERROR_DESC = "起始时间必须小于终止时间！";
    String RESOURCE_CAN_NOT_EMPTY = "70000003";
    String RESOURCE_CAN_NOT_EMPTY_DESC = "资源不能为空！";
    String UPDATE_VERSION_ADVICE_EXCITED = "70000004";
    String UPDATE_VERSION_ADVICE_EXCITED_DESC = "版本关联的版本更新通知已创建，不能重复创建！";

    String MEMBER_NOT_SHARE_QUALIFICATIONS = "80000001";
    String MEMBER_NOT_SHARE_QUALIFICATIONS_DESC = "该用户没有分享资格";

    /***************************分享错误码***********************************/

    String SHARE_ACTIVITY_NOT_EXIST = "90000001";
    String SHARE_ACTIVITY_NOT_EXIST_DESC = "分享活动不存在";

    String REDEEMCODE_EXCITED = "10000001";
    String REDEEMCODE_EXCITED_DESC = "暂不支持当前类型的兑换码生成";

    String FILE_NAME_OCCUPY = "90000002";
    String FILE_NAME_OCCUPY_DESC = "该文件名称已被占用请更换后重试";

    /***************************苹果支付错误码***********************************/
    String PAYMENT_CERTIFICATE_ERROR = "11000001";
    String PAYMENT_CERTIFICATE_ERROR_DESC = "支付凭证错误";
    String TRANSACTION_ID_NOT_DIFFERENT = "11000002";
    String TRANSACTION_ID_NOT_DIFFERENT_DESC = "交易流水号不一致";
    String INVALID_PAY_RECEIPT = "11000003";
    String INVALID_PAY_RECEIPT_DESC = "无效支付凭证";
    String APPLE_SERVER_EXCEPTION = "11000005";
    String APPLE_SERVER_EXCEPTION_DESC = "苹果服务器异常";
    String ORDER_MISMATCH = "11000006";
    String ORDER_MISMATCH_DESC = "订单号与支付凭证不匹配";

    String REQUEST_FILTER_ERROR = "11110001";
    String REQUEST_FILTER_ERROR_DESC = "请求渠道尚未开放授权";


    /***************************分级分销，海外代理商***********************************/
    String GENT_SCHOOL_DETAILS = "20000001";
    String GENT_SCHOOL_DETAILS_DESC = "学校详情数据不存在";

    /**********************************图书借阅活动**********************************/

    String ACTIVITY_TYPE_ERROR = "1300000001";
    String ACTIVITY_TYPE_DETAILS_DESC = "借阅活动类型不存在";

    String ACTIVITY_ERROR = "1300000002";
    String ACTIVITY_DETAILS_DESC = "参数有误";
}