package com.ellabook.enums;

import java.util.Objects;

import org.apache.commons.lang3.StringUtils;

public enum VipCardTypeEnum {

    /**
     * 赠送会员
     */
    CARD_SEND(0) {
        @Override
        public String getCode() {
            return "CARD-SEND";
        }
    },
    /**
     * 三天卡
     */
    CARD_THREE(1) {
        @Override
        public String getCode() {
            return "CARD_THREE";
        }
    },
    /**
     * 周卡
     */
    CARD_WEEK(2) {
        @Override
        public String getCode() {
            return "CARD_WEEK";
        }
    },
    /**
     * 月卡
     */
    CARD_MONTH(3) {
        @Override
        public String getCode() {
            return "CARD_MONTH";
        }
    },
    /**
     * 年卡
     */
    CARD_YEAR(4) {
        @Override
        public String getCode() {
            return "CARD_YEAR";
        }
    };


    private int type;

    VipCardTypeEnum(int type) {
        this.type = type;
    }

    public int getType() {
        return type;
    }

    public abstract String getCode();

    public static VipCardTypeEnum ofCode(String code) {
        if (StringUtils.isNotBlank(code)) {
            for (VipCardTypeEnum ve : VipCardTypeEnum.values()) {
                if (ve.getCode().equals(code)) {
                    return ve;
                }
            }
        }
        return null;
    }

    public static boolean contain(String code) {
        return Objects.nonNull(ofCode(code));
    }

    public boolean equalTo(String code) {
        return this.getCode().equals(code);
    }
}
