package com.ellabook.enums;

public interface LbDataEnum {


    /**
     * 数据类型枚举
     */
    enum DataTypeEnum {
        DRAFT("DRAFT", "草稿"),
        ONLINE("ONLINE", "线上");

        private final String code;

        private final String msg;


        DataTypeEnum(String code, String msg) {
            this.code = code;
            this.msg = msg;
        }


        public String msg() {
            return this.msg;
        }

        public static DataTypeEnum getEnumByCode(String code) {
            for (DataTypeEnum retCodeEnum : DataTypeEnum.values()) {
                if (retCodeEnum.code.equals(code)) {
                    return retCodeEnum;
                }
            }
            return null;
        }


        public String getCode() {
            return code;
        }


        public String getMsg() {
            return msg;
        }
    }

    /**
     * 数据类型枚举
     */
    enum StatusEnum {
        NORMAL("NORMAL", "正常"),
        DELETE("DELETE", "删除");

        private final String code;

        private final String msg;


        StatusEnum(String code, String msg) {
            this.code = code;
            this.msg = msg;
        }


        public String msg() {
            return this.msg;
        }

        public static DataTypeEnum getEnumByCode(String code) {
            for (DataTypeEnum retCodeEnum : DataTypeEnum.values()) {
                if (retCodeEnum.code.equals(code)) {
                    return retCodeEnum;
                }
            }
            return null;
        }


        public String getCode() {
            return code;
        }


        public String getMsg() {
            return msg;
        }
    }

    /**
     * 布尔类型枚举
     */
    enum BooleanEnum {
        YES("YES", "是"),
        NO("NO", "否");

        private final String code;

        private final String msg;


        BooleanEnum(String code, String msg) {
            this.code = code;
            this.msg = msg;
        }


        public String msg() {
            return this.msg;
        }

        public static BooleanEnum getEnumByCode(String code) {
            for (BooleanEnum retCodeEnum : BooleanEnum.values()) {
                if (retCodeEnum.code.equals(code)) {
                    return retCodeEnum;
                }
            }
            return null;
        }


        public String getCode() {
            return code;
        }


        public String getMsg() {
            return msg;
        }
    }

    /**
     * 展示状态枚举
     */
    enum ShowStatusEnum {
        YES("YES", "已展示"),
        NO("NO", "未展示");

        private final String code;

        private final String msg;


        ShowStatusEnum(String code, String msg) {
            this.code = code;
            this.msg = msg;
        }


        public String msg() {
            return this.msg;
        }

        public static ShowStatusEnum getEnumByCode(String code) {
            for (ShowStatusEnum retCodeEnum : ShowStatusEnum.values()) {
                if (retCodeEnum.code.equals(code)) {
                    return retCodeEnum;
                }
            }
            return null;
        }


        public String getCode() {
            return code;
        }


        public String getMsg() {
            return msg;
        }
    }


    /**
     * 布尔类型枚举
     */
    enum PublishEnum {
        YES("YES", "已发布"),
        NO("NO", "未发布");

        private final String code;

        private final String msg;


        PublishEnum(String code, String msg) {
            this.code = code;
            this.msg = msg;
        }


        public String msg() {
            return this.msg;
        }

        public static PublishEnum getEnumByCode(String code) {
            for (PublishEnum retCodeEnum : PublishEnum.values()) {
                if (retCodeEnum.code.equals(code)) {
                    return retCodeEnum;
                }
            }
            return null;
        }


        public String getCode() {
            return code;
        }


        public String getMsg() {
            return msg;
        }
    }

    /**
     * 是否需要重发枚举
     */
    enum RepulishEnum {
        YES("YES", "已发布"),
        NO("NO", "未发布");

        private final String code;

        private final String msg;


        RepulishEnum(String code, String msg) {
            this.code = code;
            this.msg = msg;
        }


        public String msg() {
            return this.msg;
        }

        public static RepulishEnum getEnumByCode(String code) {
            for (RepulishEnum retCodeEnum : RepulishEnum.values()) {
                if (retCodeEnum.code.equals(code)) {
                    return retCodeEnum;
                }
            }
            return null;
        }


        public String getCode() {
            return code;
        }


        public String getMsg() {
            return msg;
        }
    }

    /**
     * 系统自定列表分组类型
     */
    enum SystemGroupTypeEnum {
        SYSTEM_LB_COMMON("SYSTEM_INTERFACE", "听书系统界面"),
        SYSTEM_LB_LISTEN_LIST("LISTEN", "听单"),
        SYSTEM_LB_LISTEN_ARRAY("LISTEN_ARRAY", "听单合集"),
        SYSTEM_LB_LISTEN_SPECIAL("LISTEN_SPECIAL", "听单特殊路由（应对一个听单多种展示风格）");

        private final String code;

        private final String msg;


        SystemGroupTypeEnum(String code, String msg) {
            this.code = code;
            this.msg = msg;
        }


        public String msg() {
            return this.msg;
        }

        public static SystemGroupTypeEnum getEnumByCode(String code) {
            for (SystemGroupTypeEnum retCodeEnum : SystemGroupTypeEnum.values()) {
                if (retCodeEnum.code.equals(code)) {
                    return retCodeEnum;
                }
            }
            return null;
        }


        public String getCode() {
            return code;
        }


        public String getMsg() {
            return msg;
        }
    }

    /**
     * 听书模块类型
     */
    enum LbMoudleTypeEnum {
        WIKI("WIKI", "分类管理"),
        AD("AD", "广告横幅"),
        LISTEN_LIST("LISTEN_LIST", "听单"),
        LISTEN_ARRAY("LISTEN_ARRAY", "听单合集");

        private final String code;

        private final String msg;


        LbMoudleTypeEnum(String code, String msg) {
            this.code = code;
            this.msg = msg;
        }


        public String msg() {
            return this.msg;
        }

        public static LbMoudleTypeEnum getEnumByCode(String code) {
            for (LbMoudleTypeEnum retCodeEnum : LbMoudleTypeEnum.values()) {
                if (retCodeEnum.code.equals(code)) {
                    return retCodeEnum;
                }
            }
            return null;
        }


        public String getCode() {
            return code;
        }


        public String getMsg() {
            return msg;
        }
    }

    /**
     * 操作类型
     */
    enum OperTypeEnum {
        ADD("ADD", "添加"),
        CANCLE("CANCLE", "取消");

        private final String code;

        private final String msg;


        OperTypeEnum(String code, String msg) {
            this.code = code;
            this.msg = msg;
        }


        public String msg() {
            return this.msg;
        }

        public static OperTypeEnum getEnumByCode(String code) {
            for (OperTypeEnum retCodeEnum : OperTypeEnum.values()) {
                if (retCodeEnum.code.equals(code)) {
                    return retCodeEnum;
                }
            }
            return null;
        }


        public String getCode() {
            return code;
        }


        public String getMsg() {
            return msg;
        }
    }

    /**
     * 操作类型
     */
    enum BookShevelFlagEnum {
        SHELVES_ON("SHELVES_ON", "上架"),
        SHELVES_OFF("SHELVES_OFF", "下架");

        private final String code;

        private final String msg;


        BookShevelFlagEnum(String code, String msg) {
            this.code = code;
            this.msg = msg;
        }


        public String msg() {
            return this.msg;
        }

        public static BookShevelFlagEnum getEnumByCode(String code) {
            for (BookShevelFlagEnum retCodeEnum : BookShevelFlagEnum.values()) {
                if (retCodeEnum.code.equals(code)) {
                    return retCodeEnum;
                }
            }
            return null;
        }


        public String getCode() {
            return code;
        }


        public String getMsg() {
            return msg;
        }
    }
}
