package com.ellabook.entity.user.vo;


import com.ellabook.util.doc.annotations.FieldExplain;

import java.io.Serializable;

/**
 * Created by Administrator on 2017/8/30.
 */
public class PageVo implements Serializable {

    private static final long serialVersionUID = 7407799577753226119L;
    @FieldExplain(explain = "分页大小（自然数）")
    private Integer pageSize;
    @FieldExplain(explain = "页码（正整数）")
    private Integer page;

    private Integer limitStart;

    private Integer limitEnd;


    public PageVo() {
        super();
        this.page = 0;
        this.pageSize = 20;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize == null || pageSize < 1 ? 10 : pageSize;
        setLimitStart(this.limitStart);
    }

    public void setPageSizeDefault(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getPage() {
        return page;
    }

    public void setPage(Integer page) {
        this.page = page == null || page < 0 ? 0 : page;
        setLimitStart(this.limitStart);
    }

    public void setPageDefault(Integer page) {
        this.page = page;
    }

    public Integer getLimitStart() {
        if ((this.limitStart == null || this.limitStart < 0) && this.page != null && this.page > -1 && this.pageSize != null && this.pageSize > 0) {
            return this.limitStart = (this.page) * this.pageSize;
        } else {
            return this.limitStart;
        }
    }

    public void setLimitStart(Integer limitStart) {
        if ((this.limitStart == null || this.limitStart < 0) && this.page != null && this.page > -1 && this.pageSize != null && this.pageSize > 0) {
            this.limitStart = (this.page) * this.pageSize;
        } else {
            this.limitStart = limitStart;
        }
    }

    public Integer getLimitEnd() {
        return limitEnd;
    }

    public void setLimitEnd(Integer limitEnd) {
        this.limitEnd = limitEnd;
    }

    public void setStartAndEnd() {
        this.limitStart = (this.page) * this.pageSize;
    }
}
