package com.ellabook.entity.user.dto;

import com.ellabook.entity.order.VipConfig;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author D-L
 * @program: ella-server
 * @description: version2.7.6 创建预付订单后返回前端信息
 * @date 2020-12-02 15:53:37
 */
@Data
public class VipConfigInfoDetail extends VipConfig {
    /**
     * 货币缩写 人民币：CNY 美元：USD
     */
    private String currency;

    /**
     * 实付价格
     */
    private BigDecimal price;

    /**
     * IOS价格认证编码
     */
    private String iosPriceCode;

    /**
     * PayPal价格认证编码
     */
    private String paypalPriceCode;

    /**
     * 折扣系数
     */
    private Integer discountCoefficient;


    /**
     * 展示文案语言 en-us 英文,zh-cn 中文,zh-ft 中文繁体
     */
    private String language;

    /**
     * 会员商品名称
     */
    private String title;

    /**
     * 会员商品描述
     */
    private String remark;

    /**
     * 标签文案
     */
    private String tags;

    /**
     * 实付价格内容展示
     * 例如:
     * 20元/每年
     * ¥45
     */
    private String priceContent;

    /**
     * 市场价格文字
     * 如:28元/年
     */
    private String marketPriceContent;

}