package com.ellabook.entity.user.dto;

import com.ellabook.util.doc.annotations.FieldExplain;

import java.io.Serializable;
import java.util.List;
import java.util.UUID;

public class LoginAndRegisterDTO implements Serializable {
    private static final long serialVersionUID = -2987886776575749674L;
    @FieldExplain(explain = "用户uid，唯一标识")
    private String uid = "";

    @FieldExplain(explain = "用户token，令牌")
    private String token = "";

    @FieldExplain(explain = "手机号")
    private String bindMobile = "";

    @FieldExplain(explain = "用户注册状态<br>`0`:已销号<br>`1`:已注册<br>`2`:待激活")
    private String status = "1";

    @FieldExplain(explain = "是否参与过答题送书活动<br>`0`:未参加<br>`1`:已参加")
    private String hasJoinRegisterAnswerSendBook = "0";

    private String userRegisterStatus = "0";

    private String passWordStatus;//是否设置密码

    @FieldExplain(explain = "2.7.9 注册送书集合信息")
    private List<RegisterBookDTO> registerBookDTOList;

    public String getHasJoinRegisterAnswerSendBook() {
        return hasJoinRegisterAnswerSendBook;
    }

    public void setHasJoinRegisterAnswerSendBook(String hasJoinRegisterAnswerSendBook) {
        this.hasJoinRegisterAnswerSendBook = hasJoinRegisterAnswerSendBook;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
        this.setToken("U" + UUID.randomUUID().toString().replace("-", "").substring(1).toUpperCase());
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getBindMobile() {
        return bindMobile;
    }

    public void setBindMobile(String bindMobile) {
        this.bindMobile = bindMobile;
    }

    public String getUserRegisterStatus() {
        return userRegisterStatus;
    }

    public void setUserRegisterStatus(String userRegisterStatus) {
        this.userRegisterStatus = userRegisterStatus;
    }

    public String getPassWordStatus() {
        return passWordStatus;
    }

    public void setPassWordStatus(String passWordStatus) {
        this.passWordStatus = passWordStatus;
    }

    public List<RegisterBookDTO> getRegisterBookDTOList() {
        return registerBookDTOList;
    }

    public void setRegisterBookDTOList(List<RegisterBookDTO> registerBookDTOList) {
        this.registerBookDTOList = registerBookDTOList;
    }
}
