package com.ellabook.entity.user.dto;

import com.alibaba.fastjson.JSONObject;
import com.ellabook.entity.user.usertask.BaseTask;
import com.ellabook.entity.user.usertask.TaskParam;
import com.ellabook.entity.user.usertask.TaskReward;
import com.ellabook.entity.user.vo.UserTaskRecordVO;
import lombok.*;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Author: Ch
 * @Description:
 * @Date:Created 2018/11/7 16:49
 * @Modified By:
 */
@Data
//@Setter
@NoArgsConstructor
@AllArgsConstructor
public class BaseTaskDTO extends BaseTask {
    /************ task *********/
//    private Integer id;

//    @Getter
//    private String taskCode;

//    @Getter
//    private String taskName;
//
//    @Getter
//    private String taskDesc;
//
//    @Getter
//    private String taskType;

//    private String actionCode;
//
//    private String taskParam;
//
//    private Date startTime;
//
//    private Date endTime;

//    @Getter
//    private String taskImageUrl;
//
//    private String taskAcceptType;
//
//    private String rewardsAcceptType;
//
//    private Integer cycleTime;
//
//    private Integer finishTimes;
//
//    private String status;

//    private Date createTime;

//    private Date updateTime;

//    private String showFlag;

    /************* record ***************/

//    /**
//     * 任务限制参数
//     */
//    private String taskParam;
    private Date recordCreate;
    private Date recordUpdate;
    private Date publishTime;
    private Boolean current;
    private String wallShelvesFlag;
    private String targetPageType;//跳转类型 H5地址,APP内部
    private String targetPage;//跳转地址
    private String targetParam;//跳转参数
    @Getter
    private String taskWallCode;
    @Getter
    private String recordId;
    @Getter
    private String uid;
    @Getter
    private String taskStatus;
    @Getter
    private String rewardStatus;
    @Getter
    private int currentNum;
    @Getter
    private int maxNum;

    @Getter
    private List<TaskReward> rewardList = new ArrayList<>();
    /**
     * 行为名
     */
    @Getter
    private String actionName;
    /**
     * 行为类型
     */
    @Getter
    private String actionType;
    /**
     * 行为描述
     */
    @Getter
    private String actionDesc;

    public Date takePublishTime() {
        return publishTime;
    }

    public Date takeTaskCreateTime() {
        return super.getCreateTime();
    }

    public boolean toView() {
        return shelvesOn()
                //任务下线&&已领过:可展示，不可领
                || ("SHOW_OFF".equalsIgnoreCase(getShowFlag()) && getTaskStatus() != null);
    }

    public boolean shelvesOn() {
        return "SHOW_ON".equalsIgnoreCase(getShowFlag()) && "SHELVES_ON".equalsIgnoreCase(wallShelvesFlag);
    }

    public static Comparator<BaseTaskDTO> compareByTaskUpdateTime() {
        Comparator<BaseTaskDTO> comparator = (lt, rt) -> {
            Date lPublishTime = lt.takePublishTime();
            Date rPublishTime = rt.takePublishTime();
            if (lPublishTime == null && rPublishTime == null) {
                return 0;
            } else if (lPublishTime != null && rPublishTime == null) {
                return 1;
            } else if (lPublishTime == null && rPublishTime != null) {
                return -1;
            }
            return lPublishTime.compareTo(rPublishTime);
        };
        return comparator;
    }

    public Date takeRecordCreateTime() {
        return recordCreate;
    }

    public Date takeRecordUpdateTime() {
        return recordUpdate;
    }

    public boolean checkCurrent() {
        Integer cycleTime = getCycleTime();
        if (cycleTime != null && cycleTime.intValue() > 0) {
            if (recordCreate == null) {
                return false;
            }
            Date startTime = getStartTime();
            long period = recordCreate.getTime() - startTime.getTime();
            long realCycleTime = cycleTime * 1000L;    // 配置中记录的是秒，转换为毫秒循环时间
            long overTimes = Math.floorDiv(period, realCycleTime);
            Date currentCycleStartTime = new Date(startTime.getTime() + overTimes * realCycleTime);
            Date currentCycleEndTime = new Date(currentCycleStartTime.getTime() + realCycleTime);
            currentCycleEndTime = currentCycleEndTime.before(getEndTime()) ? currentCycleEndTime
                    : getEndTime();
            return checkCurrent(currentCycleStartTime, currentCycleEndTime);
        } else {
            return checkCurrent(getStartTime(), getEndTime());
        }
    }

    public boolean checkCurrent(Date currentCycleStartTime, Date currentCycleEndTime) {
        if (current == null) {
            current = recordCreate != null && !currentCycleStartTime.after(recordCreate) && !recordCreate.after(currentCycleEndTime);
        }
        return current.booleanValue();
    }


    public BaseTaskDTO update(String taskStatus, String rewardStatus, List<TaskReward> taskRewards) {
        if (StringUtils.isNotBlank(taskStatus)) {
            setTaskStatus(taskStatus);
        }
        if (StringUtils.isNotBlank(rewardStatus)) {
            setRewardStatus(rewardStatus);
        }
        if (taskRewards != null) {
            setRewardList(taskRewards);
        }
        return this;
    }

    public BaseTaskDTO createNew(String taskStatus, String rewardStatus, String recordId) {
        BaseTaskDTO newData = new BaseTaskDTO();
        BeanUtils.copyProperties(this, newData);
        newData.setPublishTime(this.takePublishTime());
        newData.setMaxNum(this.takeMaxFinishNum());
        newData.setRecordCreate(this.takeRecordCreateTime());
        newData.setRecordUpdate(this.takeRecordUpdateTime());

        String taskParam = super.getTaskParam();
        TaskParam taskParamObj = StringUtils.isBlank(taskParam) ? new TaskParam() : JSONObject.parseObject(taskParam, TaskParam.class);

        newData.setTaskStatus(taskStatus);
        newData.setRewardStatus(rewardStatus);
        newData.setCurrentNum(0);
        newData.setMaxNum(taskParamObj.getCount());
        newData.setRecordId(recordId);
        return newData;
    }

    public UserTaskRecordVO createUserTaskRecordVO() {
        String taskParam = super.getTaskParam();
        TaskParam taskParamObj = StringUtils.isBlank(taskParam) ? new TaskParam() : JSONObject.parseObject(taskParam, TaskParam.class);

        return new UserTaskRecordVO(
                recordId, getUid(),
                getTaskCode(), getTaskWallCode(),
                taskStatus, rewardStatus,
                0, taskParamObj.getCount(), null, null);
    }

    public double pointVal() {
        if (CollectionUtils.isNotEmpty(rewardList)) {
            Double totalPoint = rewardList.stream().filter(e -> StringUtils.equalsIgnoreCase("POINT", e.getRewardType())).collect(Collectors.summingDouble(e -> new BigDecimal(e.getRewardContent()).doubleValue()));
            return totalPoint;
        }

        return 0D;
    }

    public boolean countReceiveUnAvailable(int currentCount) {
        int max = takeMaxFinishNum();
        return max <= 0
                || currentCount >= max;//达到当前周期最大次数
    }

    public int takeMaxFinishNum() {
        return Optional.ofNullable(super.getFinishTimes()).orElse(1).intValue();
    }
}
