package com.ellabook.entity.user;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.io.Serializable;

@Data
@Builder
@AllArgsConstructor
public class EbMqServiceMessage implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 输入靶向文案
     */
    private String input;

    /**
     * 消息类型:rnrn值说明rntext文本消息rnimage图片消息rnlink图文链接rnminiprogrampage小程序卡片
     */
    private String msgtype;

    /**
     * 文本消息内容r
     */
    private String content;

    /**
     * 发送的图片的媒体id，通过 新增素材接口 上传图片文件获得。
     */
    private String media_id;

    /**
     * 消息标题
     */
    private String title;

    /**
     * 图文链接消息
     */
    private String description;

    /**
     * 图文链接消息被点击后跳转的链接
     */
    private String url;

    /**
     * 图文链接消息的图片链接，支持 jpg、png 格式，较好的效果为大图 640 x 320，小图 80 x 80
     */
    private String thumb_url;

    /**
     * 小程序的页面路径，跟app.json对齐，支持参数，比如pages/index/index?foo=bar
     */
    private String pagepath;

    /**
     * thumb_media_id
     */
    private String thumb_media_id;

    public EbMqServiceMessage() {
    }

}
