package com.ellabook.entity.order.vo;

import com.ellabook.entity.user.vo.PageVo;
import com.ellabook.util.doc.annotations.FieldExplain;

import java.util.Date;

/**
 * Created by Administrator on 2017/10/20.
 */
public class OrdersManageVo extends PageVo {
    @FieldExplain(explain = "日期类型 <br/> orderCreateTime:订单生成时间 <br/>orderFinishedTime:订单完成时间")
    private String dateType;
    @FieldExplain(explain = "开始时间")
    private Date startTime;
    @FieldExplain(explain = "结束时间")
    private Date endTime;
    @FieldExplain(explain = "开始时间")
    private String startTimeStr;
    @FieldExplain(explain = "结束时间")
    private String endTimeStr;
    @FieldExplain(explain = "渠道")
    private String channelCode;
    @FieldExplain(explain = "订单状态：<br/>" +
            "PAY_WAITING待支付<br/>" +
            "PAY_SUCCESS已支付<br/>" +
            "PAY_EXPIRED已失效<br/>" +
            "PAY_CANCELED已取消")
    private String orderStatus;
    @FieldExplain(explain = "支付方式：<br/>" +
            "ALIPAY-支付宝<br/>  " +
            "APPLE_IAP-苹果<br/>  " +
            "ELLA_COIN-咿啦币<br/> " +
            " HUAWEIPAY-华为<br/>   " +
            "WXPAY-微信<br/>  " +
            "CORPORATE-对公支付")
    private String orderPayType;
    @FieldExplain(explain = "商品类型:<br/>" +
            "BOOK:图书<br/>" +
            "BOOK_PACKAGE：图书包<br/>" +
            "ELLA_COIN：咿啦币<br/>" +
            "ELLA_COURSE：课程<br/>" +
            "ELLA_VIP：咿啦会员<br/>" +
            "LIBRARY：动画图书馆<br/>" +
            "ONE_CLICK_BUY：一键购买<br/>")
    private String goodsType;
    @FieldExplain(explain = "商品内容(图书，音频，咿啦币，咿啦看书会员，咿啦听书会员)")
    private String goodsSubstance;
    @FieldExplain(explain = "订单类型：<br/>" +
            "BALANCE_MEMBER_BUY-咿啦币购买会员 <br/>" +
            "BOOK_BUY-购书 <br/>" +
            "BOOK_PACKAGE_BUY-图书包 <br/>" +
            "BOOK_RENT租书<br/>" +
            "COURSE_BUY-购买课程 <br/>" +
            "ELLA_COIN_BUY-充值 <br/>" +
            "LIBRARY-图书馆 <br/>" +
            "MEMBER_BUY-现金购买会员 <br/>" +
            "ONE_CLICK_BUY:一键购买")
    private String buyType;
    @FieldExplain(explain = "搜索框搜索类型：<br/>" +
            "uid:用户uid<br/>" +
            "userNick:<br/>" +
            "用户昵称<br/>" +
            "userMobile:用户手机号<br/>" +
            "goodsCode:商品编码<br/>" +
            "bookCode:图书编码")
    private String orderManageSearchType;
    @FieldExplain(explain = "搜索内容")
    private String searchContent;
    @FieldExplain(explain = "搜索类型<br/> accurateSearch：搜索框搜索（模糊搜索） <br/> categorySearch：根据选取搜索条件搜索")
    private String searchType;

    @FieldExplain(explain = "订单导出表头")
    private String[] orderInfoVoList;

    private String orderType;
    private String countryId;
    private String bookCode;

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public String[] getOrderInfoVoList() {
        return orderInfoVoList;
    }

    public void setOrderInfoVoList(String[] orderInfoVoList) {
        this.orderInfoVoList = orderInfoVoList;
    }

    public String getDateType() {
        return dateType;
    }

    public void setDateType(String dateType) {
        this.dateType = dateType;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public String getOrderPayType() {
        return orderPayType;
    }

    public void setOrderPayType(String orderPayType) {
        this.orderPayType = orderPayType;
    }

    public String getGoodsType() {
        return goodsType;
    }

    public void setGoodsType(String goodsType) {
        this.goodsType = goodsType;
    }

    public String getGoodsSubstance() {
        return goodsSubstance;
    }

    public void setGoodsSubstance(String goodsSubstance) {
        this.goodsSubstance = goodsSubstance;
    }

    public String getBuyType() {
        return buyType;
    }

    public void setBuyType(String buyType) {
        this.buyType = buyType;
    }

    public String getOrderManageSearchType() {
        return orderManageSearchType;
    }

    public void setOrderManageSearchType(String orderManageSearchType) {
        this.orderManageSearchType = orderManageSearchType;
    }

    public String getSearchContent() {
        return searchContent;
    }

    public void setSearchContent(String searchContent) {
        this.searchContent = searchContent;
    }

    public String getSearchType() {
        return searchType;
    }

    public void setSearchType(String searchType) {
        this.searchType = searchType;
    }

    public String getStartTimeStr() {
        return startTimeStr;
    }

    public void setStartTimeStr(String startTimeStr) {
        this.startTimeStr = startTimeStr;
    }

    public String getEndTimeStr() {
        return endTimeStr;
    }

    public void setEndTimeStr(String endTimeStr) {
        this.endTimeStr = endTimeStr;
    }

    public String getCountryId() {
        return countryId;
    }

    public void setCountryId(String countryId) {
        this.countryId = countryId;
    }

    public String getBookCode() {
        return bookCode;
    }

    public void setBookCode(String bookCode) {
        this.bookCode = bookCode;
    }
}
