package com.ellabook.entity.order.vo;

import com.ellabook.util.doc.annotations.FieldExplain;

import java.math.BigDecimal;
import java.util.Date;

public class OrderInfoVo {
    @FieldExplain(explain = "订单编码")
    private String orderNo;
    @FieldExplain(explain = "用户uid")
    private String uid;
    @FieldExplain(explain = "用户昵称")
    private String userNick;
    @FieldExplain(explain = "商品类型:<br/>" +
            "BOOK:图书<br/>" +
            "BOOK_PACKAGE：图书包<br/>" +
            "ELLA_COIN：咿啦币<br/>" +
            "ELLA_COURSE：课程<br/>" +
            "ELLA_VIP：咿啦会员<br/>" +
            "LIBRARY：动画图书馆<br/>" +
            "ONE_CLICK_BUY：一键购买<br/>")
    private String goodsType;
    @FieldExplain(explain = "商品名称")
    private String goodsName;
    @FieldExplain(explain = "优惠价格")
    private BigDecimal goodsPrice;
    @FieldExplain(explain = "订单金额")
    private BigDecimal orderAmount;
    @FieldExplain(explain = "支付金额")
    private BigDecimal payAmount;
    @FieldExplain(explain = "渠道名称")
    private String channelName;
    @FieldExplain(explain = "支付方式：<br/>" +
            "ALIPAY-支付宝<br/>  " +
            "APPLE_IAP-苹果<br/>  " +
            "ELLA_COIN-咿啦币<br/> " +
            " HUAWEIPAY-华为<br/>   " +
            "WXPAY-微信<br/>  " +
            "CORPORATE-对公支付")
    private String paymentPlantform;
    @FieldExplain(explain = "订单类型：<br/>" +
            "BALANCE_MEMBER_BUY-咿啦币购买会员 <br/>" +
            "BOOK_BUY-购书 <br/>" +
            "BOOK_PACKAGE_BUY-图书包 <br/>" +
            "BOOK_RENT租书<br/>" +
            "COURSE_BUY-购买课程 <br/>" +
            "ELLA_COIN_BUY-充值 <br/>" +
            "LIBRARY-图书馆 <br/>" +
            "MEMBER_BUY-现金购买会员 <br/>" +
            "ONE_CLICK_BUY:一键购买")
    private String orderType;
    @FieldExplain(explain = "订单完成时间")
    private String finishedTime;
    @FieldExplain(explain = "订单状态：<br/>" +
            "PAY_WAITING待支付<br/>" +
            "PAY_SUCCESS已支付<br/>" +
            "PAY_EXPIRED已失效<br/>" +
            "PAY_CANCELED已取消")
    private String orderStatus;
    @FieldExplain(explain = "创建时间")
    private Date createTime;
    @FieldExplain(explain = "商品编码")
    private String goodsCode;
    @FieldExplain(explain = "物品编码")
    private String thirdCode;
    @FieldExplain(explain = "市场价")
    private BigDecimal goodsMarketprice;
    @FieldExplain(explain = "原价")
    private BigDecimal goodsSrcPrice;
    @FieldExplain(explain = "红包金额")
    private BigDecimal couponAmount;
    @FieldExplain(explain = "积分价格")
    private Integer payPoints;
    @FieldExplain(explain = "支付时间")
    private Date payTime;
    private String countryId;
    private String countryName;
    private String transactionId;
    private String currency;
    private String payTimeStr;


    public Integer getPayPoints() {
        return payPoints;
    }

    public void setPayPoints(Integer payPoints) {
        this.payPoints = payPoints;
    }

    public String getThirdCode() {
        return thirdCode;
    }

    public void setThirdCode(String thirdCode) {
        this.thirdCode = thirdCode;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo == null ? null : orderNo.trim();
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid == null ? null : uid.trim();
    }

    public String getUserNick() {
        return userNick;
    }

    public void setUserNick(String userNick) {
        this.userNick = userNick == null ? null : userNick.trim();
    }


    public String getGoodsType() {
        return goodsType;
    }

    public void setGoodsType(String goodsType) {
        this.goodsType = goodsType == null ? null : goodsType.trim();
    }

    public String getGoodsName() {
        return goodsName;
    }

    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName == null ? null : goodsName.trim();
    }

    public BigDecimal getOrderAmount() {
        return orderAmount;
    }

    public void setOrderAmount(BigDecimal orderAmount) {
        this.orderAmount = orderAmount;
    }

    public BigDecimal getPayAmount() {
        return payAmount;
    }

    public void setPayAmount(BigDecimal payAmount) {
        this.payAmount = payAmount;
    }

    public String getChannelName() {
        return channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName == null ? null : channelName.trim();
    }

    public String getPaymentPlantform() {
        return paymentPlantform;
    }

    public void setPaymentPlantform(String paymentPlantform) {
        this.paymentPlantform = paymentPlantform == null ? null : paymentPlantform.trim();
    }

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType == null ? null : orderType.trim();
    }

    public String getFinishedTime() {
        return finishedTime;
    }

    public void setFinishedTime(String finishedTime) {
        this.finishedTime = finishedTime;
    }

    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus == null ? null : orderStatus.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getGoodsCode() {
        return goodsCode;
    }

    public void setGoodsCode(String goodsCode) {
        this.goodsCode = goodsCode == null ? null : goodsCode.trim();
    }

    public BigDecimal getGoodsPrice() {
        return goodsPrice;
    }

    public void setGoodsPrice(BigDecimal goodsPrice) {
        this.goodsPrice = goodsPrice;
    }

    public BigDecimal getGoodsMarketprice() {
        return goodsMarketprice;
    }

    public void setGoodsMarketprice(BigDecimal goodsMarketprice) {
        this.goodsMarketprice = goodsMarketprice;
    }

    public BigDecimal getGoodsSrcPrice() {
        return goodsSrcPrice;
    }

    public void setGoodsSrcPrice(BigDecimal goodsSrcPrice) {
        this.goodsSrcPrice = goodsSrcPrice;
    }

    public BigDecimal getCouponAmount() {
        return couponAmount;
    }

    public void setCouponAmount(BigDecimal couponAmount) {
        this.couponAmount = couponAmount;
    }

    public Date getPayTime() {
        return payTime;
    }

    public void setPayTime(Date payTime) {
        this.payTime = payTime;
    }

    public String getCountryId() {
        return countryId;
    }

    public void setCountryId(String countryId) {
        this.countryId = countryId;
    }

    public String getCountryName() {
        return countryName;
    }

    public void setCountryName(String countryName) {
        this.countryName = countryName;
    }

    public String getTransactionId() {
        return transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getPayTimeStr() {
        return payTimeStr;
    }

    public void setPayTimeStr(String payTimeStr) {
        this.payTimeStr = payTimeStr;
    }
}