package com.ellabook.entity.order.vo;

import com.alibaba.fastjson.annotation.JSONField;
import com.ellabook.entity.operation.GoodsLimitExemptionRelation;
import com.ellabook.entity.order.GoodsChannelPriceRelation;
import com.ellabook.entity.order.dto.BookListOfBookPackageDTO;
import com.ellabook.util.parameterChecking.CheckValue;
import com.ellabook.util.parameterChecking.NotEmpty;
import org.apache.commons.collections.CollectionUtils;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

public class InsertGoodsVo {

    private String goodsCode;//商品id

    @NotEmpty
    @CheckValue()
    private String thirdCode;//物品编码

    private String thirdName;//物品名称

    @NotEmpty
    @CheckValue()
    private String goodsName;//商品名称

    @NotEmpty
    @CheckValue()
    private BigDecimal goodsPrice;//优惠售价

    @NotEmpty
    @CheckValue()
    private BigDecimal goodsSrcPrice;//原价

    @NotEmpty
    @CheckValue()
    private BigDecimal goodsMarketprice;//市场价

    private BigDecimal goodsDiscount;//折扣

    private Integer goodsIntegral;//积分价格

    private String iosPriceId;//ios价格id

    private BigDecimal iosPrice;//ios价格
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date goodsPublishTime;//上架时间
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date goodsUnpublishTime;//下架时间

    @NotEmpty
    @CheckValue()
    private String goodsSubstance;//商品内容（图书，音频，咿啦币，咿啦看书会员，咿啦听书会员）

    private Integer effectiveTime;//有效时间

    @NotEmpty
    @CheckValue()
    private String goodsType;//商品类型 BOOK-图书 LIB-图书馆 BOOK_PACKAGE-图书包 ELLA_VIP-会员 ELLA_COIN-咿啦币 ELLA_COURSE-咿啦课程

    @NotEmpty
    @CheckValue()
    private String goodsState;//商品状态 SHELVES_WAIT:待上架 ,SHELVES_ON:已上架,SHELVES_OFF;已下架,PRE_SALE:预售

    private Integer goodsSalenum;//销售数量

    private Integer goodsStorage;//商品库存
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;//创建时间
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;//更改时间
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date expireTime;//结束时间

    @NotEmpty
    @CheckValue()
    private String status;//数据状态  EXCEPTION:删除 ,NORMAL:正常

    private List<GoodsLimitExemptionRelation> goodsLimitExemptionRelationList;

    private String coverUrl;

    private String packageIntroduction;

    private String isVip;

    private String isSvip;

    /**
     * 站点code，大陆CN，其他OTHER
     */
    @NotEmpty
    private String siteCode;

    public String getSiteCode() {
        return siteCode;
    }

    public void setSiteCode(String siteCode) {
        this.siteCode = siteCode;
    }

    public String getCoverUrl() {
        return coverUrl;
    }

    public void setCoverUrl(String coverUrl) {
        this.coverUrl = coverUrl;
    }

    public String getPackageIntroduction() {
        return packageIntroduction;
    }

    public void setPackageIntroduction(String packageIntroduction) {
        this.packageIntroduction = packageIntroduction;
    }

    public Integer getGoodsIntegral() {
        return goodsIntegral;
    }

    public void setGoodsIntegral(Integer goodsIntegral) {
        this.goodsIntegral = goodsIntegral;
    }

    public List<GoodsLimitExemptionRelation> getGoodsLimitExemptionRelationList() {
        return goodsLimitExemptionRelationList;
    }

    public void setGoodsLimitExemptionRelationList(List<GoodsLimitExemptionRelation> goodsLimitExemptionRelationList) {
        this.goodsLimitExemptionRelationList = goodsLimitExemptionRelationList;
    }

    public List<GoodsChannelPriceRelation> goodsChannelPriceRelation;//渠道

    private List<String> bookCodeList;
    private List<String> courseCodeList;//课程编码

    private List<BookListOfBookPackageDTO> booksOfBookPackageList;

    private String isOffRelationGoods;//YES:是 NO:否

    private String expand1;

    private String expand2;

    private String expand3;

    private String expand4;

    private String expand5;

    public List<BookListOfBookPackageDTO> getBooksOfBookPackageList() {
        return booksOfBookPackageList;
    }

    public void setBooksOfBookPackageList(List<BookListOfBookPackageDTO> booksOfBookPackageList) {
        this.booksOfBookPackageList = booksOfBookPackageList;
    }

    public String getIsOffRelationGoods() {
        return isOffRelationGoods;
    }

    public void setIsOffRelationGoods(String isOffRelationGoods) {
        this.isOffRelationGoods = isOffRelationGoods;
    }

    public List<String> getBookCodeList() {
        return bookCodeList;
    }

    public void setBookCodeList(List<String> bookCodeList) {
        if (CollectionUtils.isNotEmpty(bookCodeList)) {
            bookCodeList.remove(null);
            bookCodeList.remove("");
        }
        this.bookCodeList = bookCodeList;
    }

    public String getGoodsCode() {
        return goodsCode;
    }

    public void setGoodsCode(String goodsCode) {
        this.goodsCode = goodsCode;
    }

    public String getThirdCode() {
        return thirdCode;
    }

    public void setThirdCode(String thirdCode) {
        this.thirdCode = thirdCode;
    }

    public String getThirdName() {
        return thirdName;
    }

    public void setThirdName(String thirdName) {
        this.thirdName = thirdName;
    }

    public String getGoodsName() {
        return goodsName;
    }

    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    public BigDecimal getGoodsPrice() {
        return goodsPrice;
    }

    public void setGoodsPrice(BigDecimal goodsPrice) {
        this.goodsPrice = goodsPrice;
    }

    public BigDecimal getGoodsSrcPrice() {
        return goodsSrcPrice;
    }

    public void setGoodsSrcPrice(BigDecimal goodsSrcPrice) {
        this.goodsSrcPrice = goodsSrcPrice;
    }

    public BigDecimal getGoodsMarketprice() {
        return goodsMarketprice;
    }

    public void setGoodsMarketprice(BigDecimal goodsMarketprice) {
        this.goodsMarketprice = goodsMarketprice;
    }

    public String getIosPriceId() {
        return iosPriceId;
    }

    public void setIosPriceId(String iosPriceId) {
        this.iosPriceId = iosPriceId;
    }

    public BigDecimal getIosPrice() {
        return iosPrice;
    }

    public void setIosPrice(BigDecimal iosPrice) {
        this.iosPrice = iosPrice;
    }

    public Date getGoodsPublishTime() {
        return goodsPublishTime;
    }

    public void setGoodsPublishTime(Date goodsPublishTime) {
        this.goodsPublishTime = goodsPublishTime;
    }

    public Date getGoodsUnpublishTime() {
        return goodsUnpublishTime;
    }

    public void setGoodsUnpublishTime(Date goodsUnpublishTime) {
        this.goodsUnpublishTime = goodsUnpublishTime;
    }

    public String getGoodsSubstance() {
        return goodsSubstance;
    }

    public void setGoodsSubstance(String goodsSubstance) {
        this.goodsSubstance = goodsSubstance;
    }

    public Integer getEffectiveTime() {
        return effectiveTime;
    }

    public void setEffectiveTime(Integer effectiveTime) {
        this.effectiveTime = effectiveTime;
    }

    public String getGoodsType() {
        return goodsType;
    }

    public void setGoodsType(String goodsType) {
        this.goodsType = goodsType;
    }

    public String getGoodsState() {
        return goodsState;
    }

    public void setGoodsState(String goodsState) {
        this.goodsState = goodsState;
    }

    public Integer getGoodsSalenum() {
        return goodsSalenum;
    }

    public void setGoodsSalenum(Integer goodsSalenum) {
        this.goodsSalenum = goodsSalenum;
    }

    public Integer getGoodsStorage() {
        return goodsStorage;
    }

    public void setGoodsStorage(Integer goodsStorage) {
        this.goodsStorage = goodsStorage;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Date getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public List<GoodsChannelPriceRelation> getGoodsChannelPriceRelation() {
        return goodsChannelPriceRelation;
    }

    public void setGoodsChannelPriceRelation(List<GoodsChannelPriceRelation> goodsChannelPriceRelation) {
        this.goodsChannelPriceRelation = goodsChannelPriceRelation;
    }

    public String getExpand1() {
        return expand1;
    }

    public void setExpand1(String expand1) {
        this.expand1 = expand1;
    }

    public String getExpand2() {
        return expand2;
    }

    public void setExpand2(String expand2) {
        this.expand2 = expand2;
    }

    public String getExpand3() {
        return expand3;
    }

    public void setExpand3(String expand3) {
        this.expand3 = expand3;
    }

    public String getExpand4() {
        return expand4;
    }

    public void setExpand4(String expand4) {
        this.expand4 = expand4;
    }

    public String getExpand5() {
        return expand5;
    }

    public void setExpand5(String expand5) {
        this.expand5 = expand5;
    }

    public List<String> getCourseCodeList() {
        return courseCodeList;
    }

    public void setCourseCodeList(List<String> courseCodeList) {
        if (CollectionUtils.isNotEmpty(courseCodeList)) {
            courseCodeList.remove(null);
            courseCodeList.remove("");
        }
        this.courseCodeList = courseCodeList;
    }

    public BigDecimal getGoodsDiscount() {
        return goodsDiscount;
    }

    public void setGoodsDiscount(BigDecimal goodsDiscount) {
        this.goodsDiscount = goodsDiscount;
    }

    public String getIsVip() {
        return isVip;
    }

    public void setIsVip(String isVip) {
        this.isVip = isVip;
    }

    public String getIsSvip() {
        return isSvip;
    }

    public void setIsSvip(String isSvip) {
        this.isSvip = isSvip;
    }
}