package com.ellabook.entity.order;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author D-L
 * @version 2.7.6
 * @program: ella-server
 * @description: 会员页面配置（主表）实体类
 * @date 2020-11-30 10:57:06
 */
@Data
public class VipConfig implements Serializable {
    private Integer id;

    /**
     * 会员商品配置编码
     */
    private String cardCode;

    /**
     * 会员售卖区域限制。
     * 1.用户注册地区域锁区。
     * 2.无用户查询时以接口调用时ip来决定。
     * <p>
     * 当前支持：
     * CN:大陆地区
     * OTHER:非大陆地区
     */
    private String country;

    /**
     * 会员激活天数（单位：天）
     */
    private Integer activeDays;

    /**
     * 临时赠送会员天数
     */
    private Integer sendDays;

    /**
     * 购买会员卡类型:
     * 年卡: YEAR_CARD
     * 月卡: MONTH_CARD
     * 周卡：WEKK_CARD
     * 连续包年：AUTO_YEAR_CARD
     * 连续包月：AUTO_MONTH_CARD
     */
    private String vipType;

    /**
     * 渠道：
     * 安卓：ANDROID
     * 苹果：IOS
     * 安卓HD：ANDROID_HD
     * 苹果HD：IOS_HD
     * 国际站:  WEBSITE_OTHER
     */
    private String channel;

    /**
     * 推荐标签 YES：展示标签，NO：不展示
     */
    private String recommendLabel;

    /**
     * 是否限制购买
     */
    private String limitBuyStatus;

    /**
     * 限制购买次数
     */
    private Integer limitNum;

    /**
     * 所在角色是否展示的角色描述，多个以逗号隔开
     * 全部：All
     * 游客：TOURIST
     * 普通用户：USER
     * 会员用户：VIP
     * 家长：PARENT
     * 教师：TEACHER
     * 园长：DIRECTOR
     */
    private String role;

    /**
     * 排序
     */
    private Integer idx;

    /**
     * 状态：
     * 正常-NORMAL 异常-EXCEPTION
     */
    private String status;

    /**
     * 创建时间
     */
    private Date createTime;

    private static final long serialVersionUID = 1L;
}