package com.ellabook.entity.order;

import lombok.Data;

@Data
public class AutoRenewNotice {
    /**
     * 通知类型
     * DID_CHANGE_RENEWAL_STATUS：表示续订状态有改变。可检查auto_renew_status_change_date_ms和auto_renew_status字段
     * CANCEL：表示用户退款了，或者用户升级了订阅。（用户升级订阅后，会退款之前的订阅）
     * DID_CHANGE_RENEWAL_PREF：表示用户更改订阅计划，会在下次订阅生效。对当前订阅无影响。
     * DID_FAIL_TO_RENEW：表示由于账单问题，续订失败。可检查is_in_billing_retry_period
     * DID_RECOVER：表示成功续订。这个是针对过去续订失败的订阅。
     * INITIAL_BUY：表示第一次订阅。
     * INTERACTIVE_RENEWAL：表示用户手动续订成功
     * RENEWAL：表示自动续订成功。（此字段苹果计划废弃，用DID_RECOVER代替。）
     */
    private String notification_type;
    /**
     * 最近交易详细信息
     */
    private String latest_receipt_info;
    /**
     * 最近交易凭证，BASE64
     */
    private String latest_receipt;
    /**
     * 最近失效详细信息
     */
    private String latest_expired_receipt_info;
    /**
     * 最近失效凭证，BASE64
     */
    private String latest_expired_receipt;
    /**
     * 自动订阅商品
     */
    private String auto_renew_product_id;
    /**
     * 环境 Sandbox:沙盒环境 ，PROD：生产环境
     */
    private String environment;
    /**
     * 密码
     */
    private String password;
    /**
     * 订阅状态改变时间戳
     */
    private String auto_renew_status_change_date_ms;
    /**
     * 商户信息
     */
    private String bid;
    /**
     * 自动订阅状态 true:订阅中 false:已取消
     */
    private String auto_renew_status;
    /**
     * 统一凭证 包含最近一次交易信息
     */
    private String unified_receipt;
}