package com.ellabook.entity.operation.vo;

import com.ellabook.entity.PublicParam;
import com.ellabook.util.parameterChecking.NotBlank;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;

import java.util.Date;

@Data
@JsonIgnoreProperties({ "siteCode"})
public class BorrowBookActivityVo extends PublicParam {

    /**
     * 借书活动编码
     */
    private String activityCode;

    /**
     * 活动名称
     */
    @NotBlank
    private String activityName;

    /**
     * 借书活动类型
     */
    private String activityType;

    /**
     * 渠道编码
     */
    private String channelCode;

    /**
     * 借书活动开始时间
     */
    @NotBlank
    private Date startTime;

    /**
     * 借书活动结束时间
     */
    @NotBlank
    private Date endTime;

    /**
     * 是否限制数量 YES,NO
     */
    private String whetherLimit;

    /**
     * 活动参与人数上限
     */
    private Integer activityAmount;

    /**
     * 送书数量
     */
    private Integer booksCount;

    /**
     * 送书组合
     */
    private String books;

    private String sendMembers;

    private String siteCode;
}
