package com.ellabook.entity.operation.dto.business;

import com.ellabook.util.parameterChecking.CheckValue;
import com.ellabook.util.parameterChecking.NotEmpty;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

public class DealerDTO {
    private String uid;
    @NotEmpty
    @CheckValue()
    private String businessTrueName;
    @NotEmpty
    @CheckValue()
    private String businessName;
    @NotEmpty
    @CheckValue()
    private String mobile;
    @NotEmpty
    @CheckValue()
    private String email;
    @NotEmpty
    @CheckValue()
    private String businessCity;
    @NotEmpty
    @CheckValue()
    private String dealerAddress;
    @NotEmpty
    @CheckValue()
    private String bankName;
    @NotEmpty
    @CheckValue()
    private String dealerInfo;
    @NotEmpty
    @CheckValue()
    private String bankNumber;
    @NotEmpty
    @CheckValue()
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date contractStartTime;
    @NotEmpty
    @CheckValue()
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date contractEndTime;
    @NotEmpty
    @CheckValue()
    private String redCodePower;
    @NotEmpty
    @CheckValue()
    private String divideType;
    private BigDecimal dividMoney;
    private double dividePercent;
    @NotEmpty
    @CheckValue()
    private BigDecimal renewMoney;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date businessRegistTime;

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getBusinessTrueName() {
        return businessTrueName;
    }

    public void setBusinessTrueName(String businessTrueName) {
        this.businessTrueName = businessTrueName;
    }

    public String getBusinessName() {
        return businessName;
    }

    public void setBusinessName(String businessName) {
        this.businessName = businessName;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getBusinessCity() {
        return businessCity;
    }

    public void setBusinessCity(String businessCity) {
        this.businessCity = businessCity;
    }

    public String getDealerAddress() {
        return dealerAddress;
    }

    public void setDealerAddress(String dealerAddress) {
        this.dealerAddress = dealerAddress;
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public String getDealerInfo() {
        return dealerInfo;
    }

    public void setDealerInfo(String dealerInfo) {
        this.dealerInfo = dealerInfo;
    }

    public String getBankNumber() {
        return bankNumber;
    }

    public void setBankNumber(String bankNumber) {
        this.bankNumber = bankNumber;
    }


    public String getRedCodePower() {
        return redCodePower;
    }

    public void setRedCodePower(String redCodePower) {
        this.redCodePower = redCodePower;
    }

    public String getDivideType() {
        return divideType;
    }

    public void setDivideType(String divideType) {
        this.divideType = divideType;
    }

    public BigDecimal getDividMoney() {
        return dividMoney;
    }

    public void setDividMoney(BigDecimal dividMoney) {
        this.dividMoney = dividMoney;
    }

    public double getDividePercent() {
        return dividePercent;
    }

    public void setDividePercent(double dividePercent) {
        this.dividePercent = dividePercent;
    }

    public BigDecimal getRenewMoney() {
        return renewMoney;
    }

    public void setRenewMoney(BigDecimal renewMoney) {
        this.renewMoney = renewMoney;
    }

    public Date getContractStartTime() {
        return contractStartTime;
    }

    public void setContractStartTime(Date contractStartTime) {
        this.contractStartTime = contractStartTime;
    }

    public Date getContractEndTime() {
        return contractEndTime;
    }

    public void setContractEndTime(Date contractEndTime) {
        this.contractEndTime = contractEndTime;
    }

    public Date getBusinessRegistTime() {
        return businessRegistTime;
    }

    public void setBusinessRegistTime(Date businessRegistTime) {
        this.businessRegistTime = businessRegistTime;
    }
}
